/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsqlUnresolvedRelation;
import org.elasticsearch.xpack.ql.analyzer.TableInfo;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        ArrayList<TableInfo> indices = new ArrayList<TableInfo>();
        ArrayList<String> policyNames = new ArrayList<String>();
        plan.forEachUp(EsqlUnresolvedRelation.class, p -> indices.add(new TableInfo(p.table(), p.frozen())));
        plan.forEachUp(Enrich.class, p -> policyNames.add((String)p.policyName().fold()));
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indices, policyNames);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(Collections.emptyList(), Collections.emptyList());
        public final List<TableInfo> indices;
        public final List<String> policyNames;

        public PreAnalysis(List<TableInfo> indices, List<String> policyNames) {
            this.indices = indices;
            this.policyNames = policyNames;
        }
    }
}

