/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli.keystore;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cli.keystore.BaseKeyStoreCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;

class AddFileKeyStoreCommand
extends BaseKeyStoreCommand {
    private final OptionSpec<String> arguments;

    AddFileKeyStoreCommand() {
        super("Add a file setting to the keystore", false);
        this.forceOption = this.parser.acceptsAll(Arrays.asList("f", "force"), "Overwrite existing setting without prompting, creating keystore if necessary");
        this.arguments = this.parser.nonOptions("(setting path)+");
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List argumentValues = this.arguments.values(options);
        if (argumentValues.size() == 0) {
            throw new UserException(64, "Missing setting name");
        }
        if (argumentValues.size() % 2 != 0) {
            throw new UserException(64, "settings and filenames must come in pairs");
        }
        KeyStoreWrapper keyStore = this.getKeyStore();
        for (int i = 0; i < argumentValues.size(); i += 2) {
            String setting = (String)argumentValues.get(i);
            if (keyStore.getSettingNames().contains(setting) && !options.has(this.forceOption) && !terminal.promptYesNo("Setting " + setting + " already exists. Overwrite?", false)) {
                terminal.println((CharSequence)"Exiting without modifying keystore.");
                return;
            }
            Path file = AddFileKeyStoreCommand.getPath((String)argumentValues.get(i + 1));
            if (!Files.exists(file, new LinkOption[0])) {
                throw new UserException(74, "File [" + file.toString() + "] does not exist");
            }
            keyStore.setFile(setting, Files.readAllBytes(file));
        }
        keyStore.save(env.configFile(), this.getKeyStorePassword().getChars());
    }

    @SuppressForbidden(reason="file arg for cli")
    private static Path getPath(String file) {
        return PathUtils.get((String)file, (String[])new String[0]);
    }
}

