/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class LongAsyncCounterAdapter
extends AbstractInstrument<ObservableLongCounter>
implements LongAsyncCounter {
    private final Supplier<LongWithAttributes> observer;
    private final ReleasableLock closedLock = new ReleasableLock((Lock)new ReentrantLock());
    private boolean closed = false;

    public LongAsyncCounterAdapter(Meter meter, String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        super(meter, name, description, unit);
        this.observer = observer;
    }

    @Override
    protected ObservableLongCounter buildInstrument(Meter meter) {
        LongCounterBuilder builder = Objects.requireNonNull(meter).counterBuilder(this.getName());
        return builder.setDescription(this.getDescription()).setUnit(this.getUnit()).buildWithCallback(measurement -> {
            LongWithAttributes observation;
            try {
                observation = this.observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                return;
            }
            measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
        });
    }

    public void close() throws Exception {
        try (ReleasableLock lock = this.closedLock.acquire();){
            if (!this.closed) {
                ((ObservableLongCounter)this.getInstrument()).close();
            }
            this.closed = true;
        }
    }
}

