/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;

public class DoubleAsyncCounterAdapter
extends AbstractInstrument<ObservableDoubleCounter>
implements DoubleAsyncCounter {
    private final Supplier<DoubleWithAttributes> observer;
    private final ReleasableLock closedLock = new ReleasableLock((Lock)new ReentrantLock());
    private boolean closed = false;

    public DoubleAsyncCounterAdapter(Meter meter, String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        super(meter, name, description, unit);
        this.observer = observer;
    }

    @Override
    protected ObservableDoubleCounter buildInstrument(Meter meter) {
        LongCounterBuilder builder = Objects.requireNonNull(meter).counterBuilder(this.getName());
        return builder.setDescription(this.getDescription()).setUnit(this.getUnit()).ofDoubles().buildWithCallback(measurement -> {
            DoubleWithAttributes observation;
            try {
                observation = this.observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                return;
            }
            measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
        });
    }

    public void close() throws Exception {
        try (ReleasableLock lock = this.closedLock.acquire();){
            if (!this.closed) {
                ((ObservableDoubleCounter)this.getInstrument()).close();
            }
            this.closed = true;
        }
    }
}

