/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collection;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class ApiKeyUserRoleDescriptorResolver {
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    public ApiKeyUserRoleDescriptorResolver(CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    public void resolveUserRoleDescriptors(Authentication authentication, ActionListener<Set<RoleDescriptor>> listener) {
        ActionListener roleDescriptorsListener = ActionListener.wrap(roleDescriptors -> {
            for (RoleDescriptor rd : roleDescriptors) {
                try {
                    DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
                }
                catch (IllegalArgumentException | ElasticsearchException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            listener.onResponse(roleDescriptors);
        }, arg_0 -> listener.onFailure(arg_0));
        Subject effectiveSubject = authentication.getEffectiveSubject();
        if (effectiveSubject.getType() == Subject.Type.API_KEY) {
            roleDescriptorsListener.onResponse(Set.of());
            return;
        }
        this.rolesStore.getRoleDescriptorsList(effectiveSubject, (ActionListener<Collection<Set<RoleDescriptor>>>)ActionListener.wrap(roleDescriptorsList -> {
            assert (roleDescriptorsList.size() == 1);
            roleDescriptorsListener.onResponse((Object)((Set)roleDescriptorsList.iterator().next()));
        }, arg_0 -> ((ActionListener)roleDescriptorsListener).onFailure(arg_0)));
    }
}

