/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.reservedstate.NonStateTransformResult;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class ReservedRoleMappingAction
implements ReservedClusterStateHandler<List<ExpressionRoleMapping>> {
    public static final String NAME = "role_mappings";
    private final NativeRoleMappingStore roleMappingStore;
    private final ListenableFuture<Void> securityIndexRecoveryListener = new ListenableFuture();

    public ReservedRoleMappingAction(NativeRoleMappingStore roleMappingStore) {
        this.roleMappingStore = roleMappingStore;
    }

    public String name() {
        return NAME;
    }

    private static Collection<PutRoleMappingRequest> prepare(List<ExpressionRoleMapping> roleMappings) {
        List<PutRoleMappingRequest> requests = roleMappings.stream().map(rm -> PutRoleMappingRequest.fromMapping((ExpressionRoleMapping)rm)).toList();
        ArrayList<Object> exceptions = new ArrayList<Object>();
        for (PutRoleMappingRequest request : requests) {
            ActionRequestValidationException exception = request.validate(false);
            if (exception == null) continue;
            exceptions.add(exception);
        }
        if (!exceptions.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("error on validating put role mapping requests");
            exceptions.forEach((Consumer<Object>)((Consumer<Exception>)illegalArgumentException::addSuppressed));
            throw illegalArgumentException;
        }
        return requests;
    }

    public TransformState transform(Object source, TransformState prevState) throws Exception {
        Collection<PutRoleMappingRequest> requests = ReservedRoleMappingAction.prepare((List)source);
        return new TransformState(prevState.state(), prevState.keys(), l -> this.securityIndexRecoveryListener.addListener(ActionListener.wrap(ignored -> this.nonStateTransform(requests, prevState, (ActionListener<NonStateTransformResult>)l), arg_0 -> ((ActionListener)l).onFailure(arg_0))));
    }

    protected void nonStateTransform(Collection<PutRoleMappingRequest> requests, TransformState prevState, final ActionListener<NonStateTransformResult> listener) {
        final Set entities = requests.stream().map(r -> r.getName()).collect(Collectors.toSet());
        HashSet toDelete = new HashSet(prevState.keys());
        toDelete.removeAll(entities);
        int tasksCount = requests.size() + toDelete.size();
        if (tasksCount == 0) {
            listener.onResponse((Object)new NonStateTransformResult(NAME, Set.of()));
            return;
        }
        GroupedActionListener taskListener = new GroupedActionListener(tasksCount, (ActionListener)new ActionListener<Collection<Boolean>>(){

            public void onResponse(Collection<Boolean> booleans) {
                listener.onResponse((Object)new NonStateTransformResult(ReservedRoleMappingAction.NAME, Collections.unmodifiableSet(entities)));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
        for (PutRoleMappingRequest request : requests) {
            this.roleMappingStore.putRoleMapping(request, (ActionListener<Boolean>)taskListener);
        }
        for (String mappingToDelete : toDelete) {
            DeleteRoleMappingRequest deleteRequest = new DeleteRoleMappingRequest();
            deleteRequest.setName(mappingToDelete);
            this.roleMappingStore.deleteRoleMapping(deleteRequest, (ActionListener<Boolean>)taskListener);
        }
    }

    public List<ExpressionRoleMapping> fromXContent(XContentParser parser) throws IOException {
        ArrayList<ExpressionRoleMapping> result = new ArrayList<ExpressionRoleMapping>();
        Map source = parser.map();
        for (String name : source.keySet()) {
            Map content = (Map)source.get(name);
            XContentParser mappingParser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (Map)content);
            try {
                ExpressionRoleMapping mapping = ExpressionRoleMapping.parse((String)name, (XContentParser)mappingParser);
                result.add(mapping);
            }
            finally {
                if (mappingParser == null) continue;
                mappingParser.close();
            }
        }
        return result;
    }

    public void securityIndexRecovered() {
        this.securityIndexRecoveryListener.onResponse(null);
    }
}

