/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.enrollment;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.StoreKeyConfig;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentRequest;
import org.elasticsearch.xpack.core.security.action.enrollment.KibanaEnrollmentResponse;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenAction;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class TransportKibanaEnrollmentAction
extends HandledTransportAction<KibanaEnrollmentRequest, KibanaEnrollmentResponse> {
    private static final Logger logger = LogManager.getLogger(TransportKibanaEnrollmentAction.class);
    private final Client client;
    private final SSLService sslService;

    @Inject
    public TransportKibanaEnrollmentAction(TransportService transportService, Client client, SSLService sslService, ActionFilters actionFilters) {
        super("cluster:admin/xpack/security/enroll/kibana", transportService, actionFilters, KibanaEnrollmentRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "security");
        this.sslService = sslService;
    }

    protected void doExecute(Task task, KibanaEnrollmentRequest request, ActionListener<KibanaEnrollmentResponse> listener) {
        List caCertificates;
        SslKeyConfig keyConfig = this.sslService.getHttpTransportSSLConfiguration().keyConfig();
        if (!(keyConfig instanceof StoreKeyConfig)) {
            listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll kibana instance. Elasticsearch node HTTP layer SSL configuration is not configured with a keystore", new Object[0])));
            return;
        }
        try {
            caCertificates = ((StoreKeyConfig)keyConfig).getKeys().stream().map(Tuple::v2).filter(x509Certificate -> x509Certificate.getBasicConstraints() != -1).collect(Collectors.toList());
        }
        catch (Exception e2) {
            listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll kibana instance. Cannot retrieve CA certificate for the HTTP layer of the Elasticsearch node.", (Throwable)e2, new Object[0])));
            return;
        }
        if (caCertificates.size() != 1) {
            listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll kibana instance. Elasticsearch node HTTP layer SSL configuration Keystore [xpack.security.http.ssl.keystore] doesn't contain a single PrivateKey entry where the associated certificate is a CA certificate", new Object[0])));
        } else {
            String httpCa;
            try {
                httpCa = Base64.getEncoder().encodeToString(((X509Certificate)caCertificates.get(0)).getEncoded());
            }
            catch (CertificateEncodingException cee) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll kibana instance. Elasticsearch node HTTP layer SSL configuration uses a malformed CA certificate", (Throwable)cee, new Object[0])));
                return;
            }
            CreateServiceAccountTokenRequest createServiceAccountTokenRequest = new CreateServiceAccountTokenRequest("elastic", "kibana", TransportKibanaEnrollmentAction.getTokenName());
            this.client.execute((ActionType)CreateServiceAccountTokenAction.INSTANCE, (ActionRequest)createServiceAccountTokenRequest, ActionListener.wrap(response -> {
                logger.debug("Successfully created token [{}] for the [elastic/kibana] service account during kibana enrollment", (Object)response.getName());
                listener.onResponse((Object)new KibanaEnrollmentResponse(response.getName(), response.getValue(), httpCa));
            }, e -> listener.onFailure((Exception)((Object)new ElasticsearchException("Failed to create token for the [elastic/kibana] service account", (Throwable)e, new Object[0])))));
        }
    }

    protected static String getTokenName() {
        ZonedDateTime enrollTime = ZonedDateTime.now(ZoneOffset.UTC);
        String prefix = "enroll-process-token-";
        return "enroll-process-token-" + enrollTime.toInstant().toEpochMilli();
    }
}

