/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.CreateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportCreateCrossClusterApiKeyAction
extends HandledTransportAction<CreateCrossClusterApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;

    @Inject
    public TransportCreateCrossClusterApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/cross_cluster/api_key/create", transportService, actionFilters, CreateCrossClusterApiKeyRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
    }

    protected void doExecute(Task task, CreateCrossClusterApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else if (authentication.isApiKey()) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication via API key not supported: An API key cannot be used to create a cross-cluster API key"));
        } else {
            this.apiKeyService.createApiKey(authentication, (AbstractCreateApiKeyRequest)request, Set.of(), listener);
        }
    }
}

