/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.rest;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureAction;

@ServerlessScope(value=Scope.INTERNAL)
public class RestFindStructureAction
extends BaseRestHandler {
    private static final TimeValue DEFAULT_TIMEOUT = new TimeValue(25L, TimeUnit.SECONDS);

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_text_structure/find_structure").replaces(RestRequest.Method.POST, "/_ml/find_file_structure", RestApiVersion.V_8).build());
    }

    public String getName() {
        return "text_structure_find_structure_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        FindStructureAction.Request request = new FindStructureAction.Request();
        request.setLinesToSample(Integer.valueOf(restRequest.paramAsInt(FindStructureAction.Request.LINES_TO_SAMPLE.getPreferredName(), 1000)));
        request.setLineMergeSizeLimit(Integer.valueOf(restRequest.paramAsInt(FindStructureAction.Request.LINE_MERGE_SIZE_LIMIT.getPreferredName(), 10000)));
        request.setTimeout(TimeValue.parseTimeValue((String)restRequest.param(FindStructureAction.Request.TIMEOUT.getPreferredName()), (TimeValue)DEFAULT_TIMEOUT, (String)FindStructureAction.Request.TIMEOUT.getPreferredName()));
        request.setCharset(restRequest.param(FindStructureAction.Request.CHARSET.getPreferredName()));
        request.setFormat(restRequest.param(FindStructureAction.Request.FORMAT.getPreferredName()));
        request.setColumnNames(restRequest.paramAsStringArray(FindStructureAction.Request.COLUMN_NAMES.getPreferredName(), null));
        request.setHasHeaderRow(restRequest.paramAsBoolean(FindStructureAction.Request.HAS_HEADER_ROW.getPreferredName(), null));
        request.setDelimiter(restRequest.param(FindStructureAction.Request.DELIMITER.getPreferredName()));
        request.setQuote(restRequest.param(FindStructureAction.Request.QUOTE.getPreferredName()));
        request.setShouldTrimFields(restRequest.paramAsBoolean(FindStructureAction.Request.SHOULD_TRIM_FIELDS.getPreferredName(), null));
        request.setGrokPattern(restRequest.param(FindStructureAction.Request.GROK_PATTERN.getPreferredName()));
        request.setEcsCompatibility(restRequest.param(FindStructureAction.Request.ECS_COMPATIBILITY.getPreferredName()));
        request.setTimestampFormat(restRequest.param(FindStructureAction.Request.TIMESTAMP_FORMAT.getPreferredName()));
        request.setTimestampField(restRequest.param(FindStructureAction.Request.TIMESTAMP_FIELD.getPreferredName()));
        if (!restRequest.hasContent()) {
            throw new ElasticsearchParseException("request body is required", new Object[0]);
        }
        request.setSample(restRequest.content());
        return channel -> client.execute((ActionType)FindStructureAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return Collections.singleton("explain");
    }
}

