/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.common.CartesianBoundingBox;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianBounds;

public class ParsedCartesianBounds
extends ParsedAggregation
implements CartesianBounds {
    @Nullable
    private CartesianBoundingBox boundingBox;
    private static final ObjectParser<ParsedCartesianBounds, Void> PARSER = new ObjectParser(ParsedCartesianBounds.class.getSimpleName(), true, ParsedCartesianBounds::new);
    private static final ConstructingObjectParser<Tuple<CartesianPoint, CartesianPoint>, Void> BOUNDS_PARSER = new ConstructingObjectParser(ParsedCartesianBounds.class.getSimpleName() + "_BOUNDS", true, args -> new Tuple((Object)((CartesianPoint)args[0]), (Object)((CartesianPoint)args[1])));
    private static final ObjectParser<CartesianPoint, Void> POINT_PARSER = new ObjectParser(ParsedCartesianBounds.class.getSimpleName() + "_POINT", true, CartesianPoint::new);

    public String getType() {
        return "cartesian_bounds";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.boundingBox != null) {
            builder.startObject(CartesianBoundingBox.BOUNDS_FIELD.getPreferredName());
            this.boundingBox.toXContentFragment(builder);
            builder.endObject();
        }
        return builder;
    }

    @Nullable
    public CartesianPoint topLeft() {
        return this.boundingBox != null ? (CartesianPoint)this.boundingBox.topLeft() : null;
    }

    @Nullable
    public CartesianPoint bottomRight() {
        return this.boundingBox != null ? (CartesianPoint)this.boundingBox.bottomRight() : null;
    }

    public static ParsedCartesianBounds fromXContent(XContentParser parser, String name) {
        ParsedCartesianBounds geoBounds = (ParsedCartesianBounds)PARSER.apply(parser, null);
        geoBounds.setName(name);
        return geoBounds;
    }

    static {
        ParsedCartesianBounds.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, bbox) -> {
            agg.boundingBox = new CartesianBoundingBox((CartesianPoint)bbox.v1(), (CartesianPoint)bbox.v2());
        }, BOUNDS_PARSER, GeoBoundingBox.BOUNDS_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), POINT_PARSER, GeoBoundingBox.TOP_LEFT_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), POINT_PARSER, GeoBoundingBox.BOTTOM_RIGHT_FIELD);
        POINT_PARSER.declareDouble(CartesianPoint::resetY, CartesianBoundingBox.Y_FIELD);
        POINT_PARSER.declareDouble(CartesianPoint::resetX, CartesianBoundingBox.X_FIELD);
    }
}

