/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.AppliedQueryRules;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRulesConfig;
import org.elasticsearch.xpack.application.rules.QueryRuleset;
import org.elasticsearch.xpack.searchbusinessrules.PinnedQueryBuilder;

public class RuleQueryBuilder
extends AbstractQueryBuilder<RuleQueryBuilder> {
    public static final String NAME = "rule_query";
    private static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
    static final ParseField MATCH_CRITERIA_FIELD = new ParseField("match_criteria", new String[0]);
    private static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);
    private final String rulesetId;
    private final Map<String, Object> matchCriteria;
    private final QueryBuilder organicQuery;
    private final List<String> pinnedIds;
    private final Supplier<List<String>> pinnedIdsSupplier;
    private final List<PinnedQueryBuilder.Item> pinnedDocs;
    private final Supplier<List<PinnedQueryBuilder.Item>> pinnedDocsSupplier;
    private static final ConstructingObjectParser<RuleQueryBuilder, Void> PARSER = new ConstructingObjectParser("rule_query", a -> {
        QueryBuilder organicQuery = (QueryBuilder)a[0];
        Map matchCriteria = (Map)a[1];
        String rulesetId = (String)a[2];
        return new RuleQueryBuilder(organicQuery, matchCriteria, rulesetId);
    });

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_500_040;
    }

    public RuleQueryBuilder(QueryBuilder organicQuery, Map<String, Object> matchCriteria, String rulesetId) {
        this(organicQuery, matchCriteria, rulesetId, null, null, null, null);
    }

    public RuleQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.organicQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.matchCriteria = in.readMap();
        this.rulesetId = in.readString();
        this.pinnedIds = in.readOptionalStringCollectionAsList();
        this.pinnedIdsSupplier = null;
        this.pinnedDocs = in.readOptionalCollectionAsList(PinnedQueryBuilder.Item::new);
        this.pinnedDocsSupplier = null;
    }

    private RuleQueryBuilder(QueryBuilder organicQuery, Map<String, Object> matchCriteria, String rulesetId, List<String> pinnedIds, List<PinnedQueryBuilder.Item> pinnedDocs, Supplier<List<String>> pinnedIdsSupplier, Supplier<List<PinnedQueryBuilder.Item>> pinnedDocsSupplier) {
        if (organicQuery == null) {
            throw new IllegalArgumentException("organicQuery must not be null");
        }
        if (matchCriteria == null || matchCriteria.isEmpty()) {
            throw new IllegalArgumentException("matchCriteria must not be null or empty");
        }
        if (Strings.isNullOrEmpty((String)rulesetId)) {
            throw new IllegalArgumentException("rulesetId must not be null or empty");
        }
        this.organicQuery = organicQuery;
        this.matchCriteria = matchCriteria;
        this.rulesetId = rulesetId;
        this.pinnedIds = pinnedIds;
        this.pinnedIdsSupplier = pinnedIdsSupplier;
        this.pinnedDocs = pinnedDocs;
        this.pinnedDocsSupplier = pinnedDocsSupplier;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.pinnedIdsSupplier != null) {
            throw new IllegalStateException("pinnedIdsSupplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        if (this.pinnedDocsSupplier != null) {
            throw new IllegalStateException("pinnedDocsSupplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
        out.writeGenericMap(this.matchCriteria);
        out.writeString(this.rulesetId);
        out.writeOptionalStringCollection(this.pinnedIds);
        out.writeOptionalCollection(this.pinnedDocs);
    }

    public String rulesetId() {
        return this.rulesetId;
    }

    public Map<String, Object> matchCriteria() {
        return this.matchCriteria;
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(ORGANIC_QUERY_FIELD.getPreferredName(), (ToXContent)this.organicQuery);
        builder.startObject(MATCH_CRITERIA_FIELD.getPreferredName());
        builder.mapContents(this.matchCriteria);
        builder.endObject();
        builder.field(RULESET_ID_FIELD.getPreferredName(), this.rulesetId);
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        if (this.pinnedIds != null && !this.pinnedIds.isEmpty() && this.pinnedDocs != null && !this.pinnedDocs.isEmpty()) {
            throw new IllegalArgumentException("applied rules contain both pinned ids and pinned docs, only one of ids or docs is allowed");
        }
        if (this.pinnedIds != null && !this.pinnedIds.isEmpty()) {
            PinnedQueryBuilder pinnedQueryBuilder = new PinnedQueryBuilder(this.organicQuery, this.pinnedIds.toArray(new String[0]));
            return pinnedQueryBuilder.toQuery(context);
        }
        if (this.pinnedDocs != null && !this.pinnedDocs.isEmpty()) {
            PinnedQueryBuilder pinnedQueryBuilder = new PinnedQueryBuilder(this.organicQuery, this.pinnedDocs.toArray(new PinnedQueryBuilder.Item[0]));
            return pinnedQueryBuilder.toQuery(context);
        }
        return this.organicQuery.toQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (this.pinnedIdsSupplier != null && this.pinnedDocsSupplier != null) {
            List<String> identifiedPinnedIds = this.pinnedIdsSupplier.get();
            List<PinnedQueryBuilder.Item> identifiedPinnedDocs = this.pinnedDocsSupplier.get();
            if (identifiedPinnedIds == null || identifiedPinnedDocs == null) {
                return this;
            }
            if (identifiedPinnedIds.isEmpty() && identifiedPinnedDocs.isEmpty()) {
                return this.organicQuery;
            }
            if (!identifiedPinnedIds.isEmpty() && !identifiedPinnedDocs.isEmpty()) {
                throw new IllegalArgumentException("applied rules contain both pinned ids and pinned docs, only one of ids or docs is allowed");
            }
            if (!identifiedPinnedIds.isEmpty()) {
                return new PinnedQueryBuilder(this.organicQuery, this.truncateList(identifiedPinnedIds).toArray(new String[0]));
            }
            return new PinnedQueryBuilder(this.organicQuery, this.truncateList(identifiedPinnedDocs).toArray(new PinnedQueryBuilder.Item[0]));
        }
        GetRequest getRequest = new GetRequest(".query-rules", this.rulesetId);
        final SetOnce pinnedIdsSetOnce = new SetOnce();
        final SetOnce pinnedDocsSetOnce = new SetOnce();
        final AppliedQueryRules appliedRules = new AppliedQueryRules();
        queryRewriteContext.registerAsyncAction((client, listener) -> {
            OriginSettingClient clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
            clientWithOrigin.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse getResponse) {
                    if (!getResponse.isExists()) {
                        throw new ResourceNotFoundException("query ruleset " + RuleQueryBuilder.this.rulesetId + " not found", new Object[0]);
                    }
                    QueryRuleset queryRuleset = QueryRuleset.fromXContentBytes(RuleQueryBuilder.this.rulesetId, getResponse.getSourceAsBytesRef(), XContentType.JSON);
                    for (QueryRule rule : queryRuleset.rules()) {
                        rule.applyRule(appliedRules, RuleQueryBuilder.this.matchCriteria);
                    }
                    pinnedIdsSetOnce.set(appliedRules.pinnedIds().stream().distinct().toList());
                    pinnedDocsSetOnce.set(appliedRules.pinnedDocs().stream().distinct().toList());
                    listener.onResponse(null);
                }

                public void onFailure(Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof IndexNotFoundException) {
                        listener.onFailure((Exception)new ResourceNotFoundException("query ruleset " + RuleQueryBuilder.this.rulesetId + " not found", new Object[0]));
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        });
        return ((RuleQueryBuilder)new RuleQueryBuilder(this.organicQuery, this.matchCriteria, this.rulesetId, null, null, () -> ((SetOnce)pinnedIdsSetOnce).get(), () -> ((SetOnce)pinnedDocsSetOnce).get()).boost(this.boost)).queryName(this.queryName);
    }

    private List<?> truncateList(List<?> input) {
        if (input.size() > 100) {
            HeaderWarning.addWarning((String)"Truncating query rule pinned hits to 100 documents", (Object[])new Object[0]);
            return input.subList(0, 100);
        }
        return input;
    }

    protected boolean doEquals(RuleQueryBuilder other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != ((Object)((Object)other)).getClass()) {
            return false;
        }
        return Objects.equals(this.rulesetId, other.rulesetId) && Objects.equals(this.matchCriteria, other.matchCriteria) && Objects.equals(this.organicQuery, other.organicQuery) && Objects.equals(this.pinnedIds, other.pinnedIds) && Objects.equals(this.pinnedDocs, other.pinnedDocs) && Objects.equals(this.pinnedIdsSupplier, other.pinnedIdsSupplier) && Objects.equals(this.pinnedDocsSupplier, other.pinnedDocsSupplier);
    }

    protected int doHashCode() {
        return Objects.hash(this.rulesetId, this.matchCriteria, this.organicQuery, this.pinnedIds, this.pinnedDocs, this.pinnedIdsSupplier, this.pinnedDocsSupplier);
    }

    public static RuleQueryBuilder fromXContent(XContentParser parser, XPackLicenseState licenseState) {
        if (!QueryRulesConfig.QUERY_RULES_LICENSE_FEATURE.check(licenseState)) {
            throw LicenseUtils.newComplianceException((String)NAME);
        }
        try {
            return (RuleQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RuleQueryBuilder.parseInnerQueryBuilder((XContentParser)p), ORGANIC_QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), MATCH_CRITERIA_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), RULESET_ID_FIELD);
        RuleQueryBuilder.declareStandardFields(PARSER);
    }
}

