/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public class ListConnectorAction
extends ActionType<Response> {
    public static final ListConnectorAction INSTANCE = new ListConnectorAction();
    public static final String NAME = "cluster:admin/xpack/connector/list";

    public ListConnectorAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField RESULT_FIELD = new ParseField("results", new String[0]);
        final QueryPage<Connector> queryPage;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.queryPage = new QueryPage(in, Connector::new);
        }

        public Response(List<Connector> items, Long totalResults) {
            this.queryPage = new QueryPage(items, totalResults.longValue(), RESULT_FIELD);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryPage.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryPage.toXContent(builder, params);
        }

        public QueryPage<Connector> queryPage() {
            return this.queryPage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.queryPage.equals(that.queryPage);
        }

        public int hashCode() {
            return this.queryPage.hashCode();
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final PageParams pageParams;
        private static final ParseField PAGE_PARAMS_FIELD = new ParseField("pageParams", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("list_connector_request", p -> new Request((PageParams)p[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.pageParams = new PageParams(in);
        }

        public Request(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.pageParams.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.pageParams, that.pageParams);
        }

        public int hashCode() {
            return Objects.hash(this.pageParams);
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PAGE_PARAMS_FIELD.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PageParams.fromXContent((XContentParser)p), PAGE_PARAMS_FIELD);
        }
    }
}

