/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationTemplate;
import org.elasticsearch.xpack.application.search.SearchTemplateHelper;

public class SearchApplicationTemplateService {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;

    public SearchApplicationTemplateService(ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
    }

    public SearchSourceBuilder renderQuery(SearchApplication searchApplication, Map<String, Object> templateParams) throws IOException, ValidationException, XContentParseException {
        String requestSource;
        SearchApplicationTemplate template = searchApplication.searchApplicationTemplateOrDefault();
        template.validateTemplateParams(templateParams);
        Map<String, Object> renderedTemplateParams = this.renderTemplateParams(template, templateParams);
        Script script = template.script();
        TemplateScript compiledTemplate = ((TemplateScript.Factory)this.scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(renderedTemplateParams);
        try {
            requestSource = SearchTemplateHelper.stripTrailingComma(compiledTemplate.execute());
        }
        catch (JsonProcessingException e) {
            JsonLocation loc = e.getLocation();
            throw new XContentParseException(new XContentLocation(loc.getLineNr(), loc.getColumnNr()), e.getMessage(), (Exception)((Object)e));
        }
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, requestSource);){
            SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
            builder.parseXContent(parser, false);
            SearchSourceBuilder searchSourceBuilder = builder;
            return searchSourceBuilder;
        }
    }

    public Map<String, Object> renderTemplate(SearchApplication searchApplication, Map<String, Object> queryParams) throws ValidationException {
        SearchApplicationTemplate template = searchApplication.searchApplicationTemplateOrDefault();
        return this.renderTemplateParams(template, queryParams);
    }

    private Map<String, Object> renderTemplateParams(SearchApplicationTemplate template, Map<String, Object> queryParams) {
        Script script = template.script();
        HashMap<String, Object> mergedTemplateParams = new HashMap<String, Object>(script.getParams());
        mergedTemplateParams.putAll(queryParams);
        return mergedTemplateParams;
    }
}

