/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.filtering;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidation;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationState;

public class FilteringValidationInfo
implements Writeable,
ToXContentObject {
    private final List<FilteringValidation> validationErrors;
    private final FilteringValidationState validationState;
    private static final ParseField ERRORS_FIELD = new ParseField("errors", new String[0]);
    private static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    private static final ConstructingObjectParser<FilteringValidationInfo, Void> PARSER = new ConstructingObjectParser("filtering_validation_info", true, args -> new Builder().setValidationErrors((List)args[0]).setValidationState((FilteringValidationState)((Object)((Object)args[1]))).build());

    public FilteringValidationInfo(List<FilteringValidation> validationErrors, FilteringValidationState validationState) {
        this.validationErrors = validationErrors;
        this.validationState = validationState;
    }

    public FilteringValidationInfo(StreamInput in) throws IOException {
        this.validationErrors = in.readCollectionAsList(FilteringValidation::new);
        this.validationState = (FilteringValidationState)in.readEnum(FilteringValidationState.class);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ERRORS_FIELD.getPreferredName(), this.validationErrors);
        builder.field(STATE_FIELD.getPreferredName(), (Enum)this.validationState);
        builder.endObject();
        return builder;
    }

    public static FilteringValidationInfo fromXContent(XContentParser parser) throws IOException {
        return (FilteringValidationInfo)PARSER.parse(parser, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.validationErrors);
        out.writeEnum((Enum)this.validationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringValidationInfo that = (FilteringValidationInfo)o;
        return Objects.equals(this.validationErrors, that.validationErrors) && this.validationState == that.validationState;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.validationErrors, this.validationState});
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringValidation.fromXContent(p), ERRORS_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringValidationState.filteringValidationState(p.text()), STATE_FIELD, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private List<FilteringValidation> validationErrors;
        private FilteringValidationState validationState;

        public Builder setValidationErrors(List<FilteringValidation> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        public Builder setValidationState(FilteringValidationState validationState) {
            this.validationState = validationState;
            return this;
        }

        public FilteringValidationInfo build() {
            return new FilteringValidationInfo(this.validationErrors, this.validationState);
        }
    }
}

