/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import java.io.IOException;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

public abstract class EnterpriseSearchBaseRestHandler
extends BaseRestHandler {
    protected final XPackLicenseState licenseState;
    protected final LicenseUtils.Product product;

    protected EnterpriseSearchBaseRestHandler(XPackLicenseState licenseState, LicenseUtils.Product product) {
        this.licenseState = licenseState;
        this.product = product;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (LicenseUtils.supportedLicense(this.licenseState)) {
            return this.innerPrepareRequest(request, client);
        }
        request.params().keySet().forEach(key -> request.param(key, ""));
        request.content();
        return channel -> channel.sendResponse(new RestResponse(channel, (Exception)LicenseUtils.newComplianceException(this.licenseState, this.product)));
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;
}

