/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.support;

import java.util.Locale;
import java.util.function.LongSupplier;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AnalyticsValuesSourceType implements ValuesSourceType
{
    HISTOGRAM{

        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped HistogramValuesSource type " + this.value());
        }

        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw AggregationErrors.valuesSourceDoesNotSupportScritps((String)this.value());
        }

        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData indexFieldData = fieldContext.indexFieldData();
            if (!(indexFieldData instanceof IndexHistogramFieldData)) {
                throw new IllegalArgumentException("Expected histogram type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new HistogramValuesSource.Histogram.Fielddata((IndexHistogramFieldData)indexFieldData);
        }

        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
            throw new IllegalArgumentException("Can't apply missing values on a " + valuesSource.getClass());
        }
    };


    public static ValuesSourceType fromString(String name) {
        return AnalyticsValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String typeName() {
        return this.value();
    }
}

