/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.timeseries;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.aggregations.bucket.timeseries.TimeSeriesAggregationFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TimeSeriesAggregationBuilder
extends AbstractAggregationBuilder<TimeSeriesAggregationBuilder> {
    public static final String NAME = "time_series";
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final InstantiatingObjectParser<TimeSeriesAggregationBuilder, String> PARSER;
    private boolean keyed;
    private int size;
    private static final int DEFAULT_SIZE = 65536;

    public TimeSeriesAggregationBuilder(String name) {
        this(name, true, 65536);
    }

    public TimeSeriesAggregationBuilder(String name, Boolean keyed) {
        this(name, keyed, 65536);
    }

    @ParserConstructor
    public TimeSeriesAggregationBuilder(String name, Boolean keyed, Integer size) {
        super(name);
        this.keyed = keyed != null ? keyed : true;
        this.size = size != null ? size : 65536;
    }

    protected TimeSeriesAggregationBuilder(TimeSeriesAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.keyed = clone.keyed;
        this.size = clone.size;
    }

    public TimeSeriesAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        this.size = in.readVInt();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.size);
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new TimeSeriesAggregationFactory(this.name, this.keyed, this.size, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(SIZE_FIELD.getPreferredName(), this.size);
        builder.endObject();
        return builder;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new TimeSeriesAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    public String getType() {
        return NAME;
    }

    public boolean isInSortOrderExecutionRequired() {
        return true;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public TimeSeriesAggregationBuilder setSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.size = size;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeSeriesAggregationBuilder that = (TimeSeriesAggregationBuilder)((Object)o);
        return this.keyed == that.keyed;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyed);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_1_0;
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)NAME, (boolean)false, TimeSeriesAggregationBuilder.class);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), KEYED_FIELD);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE_FIELD);
        PARSER = parser.build();
    }
}

