/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.elser;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record HuggingFaceElserSecretSettings(SecureString apiKey) implements SecretSettings
{
    public static final String NAME = "hugging_face_elser_secret_settings";
    static final String API_KEY = "api_key";

    public HuggingFaceElserSecretSettings {
        Objects.requireNonNull(apiKey);
    }

    public HuggingFaceElserSecretSettings(StreamInput in) throws IOException {
        this(in.readSecureString());
    }

    public static HuggingFaceElserSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        SecureString secureApiToken = ServiceUtils.extractRequiredSecureString(map, API_KEY, "secret_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new HuggingFaceElserSecretSettings(secureApiToken);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(API_KEY, this.apiKey.toString());
        builder.endObject();
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_TASK_SETTINGS_OPTIONAL_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeSecureString(this.apiKey);
    }
}

