/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.openai;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.openai.OpenAiAccount;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.external.request.openai.OpenAiUtils;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsTaskSettings;

public class OpenAiEmbeddingsRequest
implements Request {
    private final Truncator truncator;
    private final OpenAiAccount account;
    private final Truncator.TruncationResult truncationResult;
    private final URI uri;
    private final OpenAiEmbeddingsTaskSettings taskSettings;

    public OpenAiEmbeddingsRequest(Truncator truncator, OpenAiAccount account, Truncator.TruncationResult input, OpenAiEmbeddingsTaskSettings taskSettings) {
        this.truncator = Objects.requireNonNull(truncator);
        this.account = Objects.requireNonNull(account);
        this.truncationResult = Objects.requireNonNull(input);
        this.uri = OpenAiEmbeddingsRequest.buildUri(this.account.url());
        this.taskSettings = Objects.requireNonNull(taskSettings);
    }

    private static URI buildUri(URI accountUri) {
        try {
            return accountUri == null ? OpenAiEmbeddingsRequest.buildDefaultUri() : accountUri;
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException("Failed to construct OpenAI URL", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public HttpRequestBase createRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new OpenAiEmbeddingsRequestEntity(this.truncationResult.input(), this.taskSettings.model(), this.taskSettings.user())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        httpPost.setHeader(RequestUtils.createAuthBearerHeader(this.account.apiKey()));
        String org = this.account.organizationId();
        if (org != null) {
            httpPost.setHeader(OpenAiUtils.createOrgHeader(org));
        }
        return httpPost;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new OpenAiEmbeddingsRequest(this.truncator, this.account, truncatedInput, this.taskSettings);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }

    static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.openai.com").setPathSegments(new String[]{"v1", "embeddings"}).build();
    }
}

