/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.io.IOException;
import java.util.Objects;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class AlwaysRetryingResponseHandler
implements ResponseHandler {
    protected final String requestType;
    private final CheckedFunction<HttpResult, InferenceServiceResults, IOException> parseFunction;

    public AlwaysRetryingResponseHandler(String requestType, CheckedFunction<HttpResult, InferenceServiceResults, IOException> parseFunction) {
        this.requestType = Objects.requireNonNull(requestType);
        this.parseFunction = Objects.requireNonNull(parseFunction);
    }

    @Override
    public void validateResponse(ThrottlerManager throttlerManager, Logger logger, HttpRequestBase request, HttpResult result) throws RetryException {
        try {
            HttpUtils.checkForFailureStatusCode(throttlerManager, logger, request, result);
            HttpUtils.checkForEmptyBody(throttlerManager, logger, request, result);
        }
        catch (Exception e) {
            throw new RetryException(true, e);
        }
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, HttpResult result) throws RetryException {
        try {
            return (InferenceServiceResults)this.parseFunction.apply((Object)result);
        }
        catch (Exception e) {
            throw new RetryException(true, e);
        }
    }
}

