/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.transport.actions.QueryWatchesAction;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportQueryWatchesAction
extends WatcherTransportAction<QueryWatchesAction.Request, QueryWatchesAction.Response> {
    private final Clock clock;
    private final Client client;
    private final WatchParser parser;

    @Inject
    public TransportQueryWatchesAction(TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, ClockHolder clockHolder, Client client, WatchParser parser) {
        super("cluster:monitor/xpack/watcher/watch/query", transportService, actionFilters, licenseState, QueryWatchesAction.Request::new);
        this.clock = clockHolder.clock;
        this.client = client;
        this.parser = parser;
    }

    @Override
    protected void doExecute(QueryWatchesAction.Request request, ActionListener<QueryWatchesAction.Response> listener) {
        SearchRequest searchRequest = this.createSearchRequest(request);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(r -> this.transformResponse((SearchResponse)r, listener), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    SearchRequest createSearchRequest(QueryWatchesAction.Request request) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".watches"});
        if (request.getFrom() != null) {
            searchRequest.source().from(request.getFrom().intValue());
        }
        if (request.getSize() != null) {
            searchRequest.source().size(request.getSize().intValue());
        }
        if (request.getQuery() != null) {
            searchRequest.source().query(request.getQuery());
        }
        if (request.getSorts() != null) {
            for (FieldSortBuilder sort : request.getSorts()) {
                searchRequest.source().sort((SortBuilder)sort);
            }
        }
        if (request.getSearchAfter() != null) {
            searchRequest.source().searchAfter(request.getSearchAfter().getSortValues());
        }
        searchRequest.source().trackTotalHits(true);
        searchRequest.source().seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        return searchRequest;
    }

    void transformResponse(SearchResponse searchResponse, ActionListener<QueryWatchesAction.Response> listener) {
        assert (searchResponse.getHits().getTotalHits().relation == TotalHits.Relation.EQUAL_TO);
        List<QueryWatchesAction.Response.Item> items = Arrays.stream(searchResponse.getHits().getHits()).map(this::transformSearchHit).toList();
        listener.onResponse((Object)new QueryWatchesAction.Response(searchResponse.getHits().getTotalHits().value, items));
    }

    QueryWatchesAction.Response.Item transformSearchHit(SearchHit searchHit) {
        QueryWatchesAction.Response.Item item;
        block8: {
            ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                Watch watch = this.parser.parseWithSecrets(searchHit.getId(), true, searchHit.getSourceRef(), now, XContentType.JSON, searchHit.getSeqNo(), searchHit.getPrimaryTerm());
                watch.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).includeStatus(false).build());
                item = new QueryWatchesAction.Response.Item(searchHit.getId(), new XContentSource(builder), watch.status(), watch.getSourceSeqNo(), watch.getSourcePrimaryTerm());
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            builder.close();
        }
        return item;
    }
}

