/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.logging;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingLevel;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;

public class LoggingAction
implements Action {
    public static final String TYPE = "logging";
    final TextTemplate text;
    @Nullable
    final LoggingLevel level;
    @Nullable
    final String category;

    public LoggingAction(TextTemplate text, @Nullable LoggingLevel level, @Nullable String category) {
        this.text = text;
        this.level = level != null ? level : LoggingLevel.INFO;
        this.category = category;
    }

    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingAction action = (LoggingAction)o;
        return Objects.equals(this.text, action.text) && this.level == action.level && Objects.equals(this.category, action.category);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.category != null) {
            builder.field(Field.CATEGORY.getPreferredName(), this.category);
        }
        builder.field(Field.LEVEL.getPreferredName(), this.level.value());
        builder.field(Field.TEXT.getPreferredName(), (ToXContent)this.text, params);
        return builder.endObject();
    }

    public static LoggingAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String category = null;
        LoggingLevel level = null;
        TextTemplate text = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.TEXT.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    text = TextTemplate.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. failed to parse [{}] field", (Throwable)pe, new Object[]{TYPE, watchId, actionId, Field.TEXT.getPreferredName()});
                }
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.CATEGORY.match(currentFieldName, parser.getDeprecationHandler())) {
                    category = parser.text();
                    continue;
                }
                if (Field.LEVEL.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        level = LoggingLevel.valueOf(parser.text().toUpperCase(Locale.ROOT));
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unknown logging level [{}]", new Object[]{TYPE, watchId, actionId, parser.text()});
                    }
                }
                throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unexpected string field [{}]", new Object[]{TYPE, watchId, actionId, currentFieldName});
            }
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unexpected token [{}]", new Object[]{TYPE, watchId, actionId, token});
        }
        if (text == null) {
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. missing required [{}] field", new Object[]{TYPE, watchId, actionId, Field.TEXT.getPreferredName()});
        }
        return new LoggingAction(text, level, category);
    }

    public static Builder builder(TextTemplate template) {
        return new Builder(template);
    }

    static interface Field {
        public static final ParseField CATEGORY = new ParseField("category", new String[0]);
        public static final ParseField LEVEL = new ParseField("level", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField LOGGED_TEXT = new ParseField("logged_text", new String[0]);
    }

    public static class Builder
    implements Action.Builder<LoggingAction> {
        final TextTemplate text;
        LoggingLevel level;
        @Nullable
        String category;

        private Builder(TextTemplate text) {
            this.text = text;
        }

        public Builder setLevel(LoggingLevel level) {
            this.level = level;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public LoggingAction build() {
            return new LoggingAction(this.text, this.level, this.category);
        }
    }

    public static interface Result {

        public static class Simulated
        extends Action.Result
        implements Result {
            private final String loggedText;

            protected Simulated(String loggedText) {
                super(LoggingAction.TYPE, Action.Result.Status.SIMULATED);
                this.loggedText = loggedText;
            }

            public String loggedText() {
                return this.loggedText;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.LOGGED_TEXT.getPreferredName(), this.loggedText).endObject();
            }
        }

        public static class Success
        extends Action.Result
        implements Result {
            private final String loggedText;

            public Success(String loggedText) {
                super(LoggingAction.TYPE, Action.Result.Status.SUCCESS);
                this.loggedText = loggedText;
            }

            public String loggedText() {
                return this.loggedText;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.LOGGED_TEXT.getPreferredName(), this.loggedText).endObject();
            }
        }
    }
}

