/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.ingest.DropProcessor;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.AppendProcessor;
import org.elasticsearch.ingest.common.BytesProcessor;
import org.elasticsearch.ingest.common.CommunityIdProcessor;
import org.elasticsearch.ingest.common.ConvertProcessor;
import org.elasticsearch.ingest.common.CsvProcessor;
import org.elasticsearch.ingest.common.DateIndexNameProcessor;
import org.elasticsearch.ingest.common.DateProcessor;
import org.elasticsearch.ingest.common.DissectProcessor;
import org.elasticsearch.ingest.common.DotExpanderProcessor;
import org.elasticsearch.ingest.common.FailProcessor;
import org.elasticsearch.ingest.common.FingerprintProcessor;
import org.elasticsearch.ingest.common.ForEachProcessor;
import org.elasticsearch.ingest.common.GrokProcessor;
import org.elasticsearch.ingest.common.GrokProcessorGetAction;
import org.elasticsearch.ingest.common.GsubProcessor;
import org.elasticsearch.ingest.common.HtmlStripProcessor;
import org.elasticsearch.ingest.common.JoinProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.KeyValueProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.NetworkDirectionProcessor;
import org.elasticsearch.ingest.common.RegisteredDomainProcessor;
import org.elasticsearch.ingest.common.RemoveProcessor;
import org.elasticsearch.ingest.common.RenameProcessor;
import org.elasticsearch.ingest.common.RerouteProcessor;
import org.elasticsearch.ingest.common.ScriptProcessor;
import org.elasticsearch.ingest.common.SetProcessor;
import org.elasticsearch.ingest.common.SortProcessor;
import org.elasticsearch.ingest.common.SplitProcessor;
import org.elasticsearch.ingest.common.TrimProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.ingest.common.UriPartsProcessor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class IngestCommonPlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Map.ofEntries(Map.entry("append", new AppendProcessor.Factory(parameters.scriptService)), Map.entry("bytes", new BytesProcessor.Factory()), Map.entry("community_id", new CommunityIdProcessor.Factory()), Map.entry("convert", new ConvertProcessor.Factory()), Map.entry("csv", new CsvProcessor.Factory()), Map.entry("date_index_name", new DateIndexNameProcessor.Factory(parameters.scriptService)), Map.entry("date", new DateProcessor.Factory(parameters.scriptService)), Map.entry("dissect", new DissectProcessor.Factory()), Map.entry("dot_expander", new DotExpanderProcessor.Factory()), Map.entry("drop", new DropProcessor.Factory()), Map.entry("fail", new FailProcessor.Factory(parameters.scriptService)), Map.entry("fingerprint", new FingerprintProcessor.Factory()), Map.entry("foreach", new ForEachProcessor.Factory(parameters.scriptService)), Map.entry("grok", new GrokProcessor.Factory(parameters.matcherWatchdog)), Map.entry("gsub", new GsubProcessor.Factory()), Map.entry("html_strip", new HtmlStripProcessor.Factory()), Map.entry("join", new JoinProcessor.Factory()), Map.entry("json", new JsonProcessor.Factory()), Map.entry("kv", new KeyValueProcessor.Factory(parameters.scriptService)), Map.entry("lowercase", new LowercaseProcessor.Factory()), Map.entry("network_direction", new NetworkDirectionProcessor.Factory(parameters.scriptService)), Map.entry("pipeline", new PipelineProcessor.Factory(parameters.ingestService)), Map.entry("registered_domain", new RegisteredDomainProcessor.Factory()), Map.entry("remove", new RemoveProcessor.Factory(parameters.scriptService)), Map.entry("rename", new RenameProcessor.Factory(parameters.scriptService)), Map.entry("reroute", new RerouteProcessor.Factory()), Map.entry("script", new ScriptProcessor.Factory(parameters.scriptService)), Map.entry("set", new SetProcessor.Factory(parameters.scriptService)), Map.entry("sort", new SortProcessor.Factory()), Map.entry("split", new SplitProcessor.Factory()), Map.entry("trim", new TrimProcessor.Factory()), Map.entry("urldecode", new URLDecodeProcessor.Factory()), Map.entry("uppercase", new UppercaseProcessor.Factory()), Map.entry("uri_parts", new UriPartsProcessor.Factory()));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler(GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new GrokProcessorGetAction.RestAction());
    }
}

