/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeDocValuesQuery;

class LatLonShapeDocValuesQuery
extends ShapeDocValuesQuery<LatLonGeometry> {
    LatLonShapeDocValuesQuery(String field, ShapeField.QueryRelation relation, LatLonGeometry ... geometries) {
        super(field, CoordinateEncoder.GEO, relation, geometries);
    }

    @Override
    protected Component2D create(LatLonGeometry[] geometries) {
        return LatLonGeometry.create((LatLonGeometry[])geometries);
    }

    @Override
    protected Component2D create(LatLonGeometry geometry) {
        return LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{geometry});
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void add(List<Component2D> components2D, LatLonGeometry geometry) {
        if (geometry instanceof Rectangle) {
            Rectangle r = (Rectangle)geometry;
            if (r.minLon > r.maxLon) {
                super.add(components2D, new Rectangle(r.minLat, r.maxLat, r.minLon, 180.0));
                super.add(components2D, new Rectangle(r.minLat, r.maxLat, -180.0, r.maxLon));
                return;
            }
        }
        super.add(components2D, geometry);
    }
}

