/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.logstash.action.PutPipelineRequest;
import org.elasticsearch.xpack.logstash.action.PutPipelineResponse;

public class TransportPutPipelineAction
extends HandledTransportAction<PutPipelineRequest, PutPipelineResponse> {
    private final Client client;

    @Inject
    public TransportPutPipelineAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/logstash/pipeline/put", transportService, actionFilters, PutPipelineRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "logstash_management");
    }

    protected void doExecute(Task task, PutPipelineRequest request, ActionListener<PutPipelineResponse> listener) {
        ((IndexRequestBuilder)this.client.prepareIndex(".logstash").setId(request.id()).setSource(request.source(), request.xContentType()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute(listener.delegateFailureAndWrap((l, indexResponse) -> l.onResponse((Object)new PutPipelineResponse(indexResponse.status()))));
    }
}

