/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.azure.storage.blob.implementation.models.ContainersAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersCreateHeaders;
import com.azure.storage.blob.implementation.models.ContainersDeleteHeaders;
import com.azure.storage.blob.implementation.models.ContainersFilterBlobsHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.ContainersGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentHeaders;
import com.azure.storage.blob.implementation.models.ContainersReleaseLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersRenameHeaders;
import com.azure.storage.blob.implementation.models.ContainersRenewLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersRestoreHeaders;
import com.azure.storage.blob.implementation.models.ContainersSetAccessPolicyHeaders;
import com.azure.storage.blob.implementation.models.ContainersSetMetadataHeaders;
import com.azure.storage.blob.implementation.models.ContainersSubmitBatchHeaders;
import com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.azure.storage.blob.implementation.models.ListBlobsFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.PublicAccessType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainersImpl {
    private final ContainersService service;
    private final AzureBlobStorageImpl client;

    ContainersImpl(AzureBlobStorageImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersCreateHeaders, Void>> createWithResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        String restype = "container";
        String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), containerName, "container", timeout, metadata, access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersCreateHeaders, Void>> createWithResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        String restype = "container";
        String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return this.service.create(this.client.getUrl(), containerName, "container", timeout, metadata, access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        return this.createWithResponseAsync(containerName, timeout, metadata, access, requestId, blobContainerEncryptionScope).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        return this.createWithResponseAsync(containerName, timeout, metadata, access, requestId, blobContainerEncryptionScope, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        String restype = "container";
        String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return FluxUtil.withContext(context -> this.service.createNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, metadata, access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        String restype = "container";
        String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return this.service.createNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, metadata, access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        String restype = "container";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), containerName, "container", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), containerName, "container", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        return this.getPropertiesWithResponseAsync(containerName, timeout, leaseId, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(containerName, timeout, leaseId, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        String restype = "container";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersDeleteHeaders, Void>> deleteWithResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String restype = "container";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), containerName, "container", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersDeleteHeaders, Void>> deleteWithResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), containerName, "container", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.deleteWithResponseAsync(containerName, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.deleteWithResponseAsync(containerName, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String restype = "container";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.deleteNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), containerName, "container", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        String restype = "container";
        String comp = "metadata";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return FluxUtil.withContext(context -> this.service.setMetadata(this.client.getUrl(), containerName, "container", "metadata", timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        String restype = "container";
        String comp = "metadata";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return this.service.setMetadata(this.client.getUrl(), containerName, "container", "metadata", timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        return this.setMetadataWithResponseAsync(containerName, timeout, leaseId, metadata, ifModifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        return this.setMetadataWithResponseAsync(containerName, timeout, leaseId, metadata, ifModifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        String restype = "container";
        String comp = "metadata";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return FluxUtil.withContext(context -> this.service.setMetadataNoCustomHeaders(this.client.getUrl(), containerName, "container", "metadata", timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        String restype = "container";
        String comp = "metadata";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return this.service.setMetadataNoCustomHeaders(this.client.getUrl(), containerName, "container", "metadata", timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccessPolicyHeaders, List<BlobSignedIdentifier>>> getAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccessPolicyHeaders, List<BlobSignedIdentifier>>> getAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<BlobSignedIdentifier>> getAccessPolicyAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        return this.getAccessPolicyWithResponseAsync(containerName, timeout, leaseId, requestId).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<BlobSignedIdentifier>> getAccessPolicyAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        return this.getAccessPolicyWithResponseAsync(containerName, timeout, leaseId, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<BlobSignedIdentifier>>> getAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<BlobSignedIdentifier>>> getAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        return FluxUtil.withContext(context -> this.service.setAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, containerAclConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, containerAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl) {
        return this.setAccessPolicyWithResponseAsync(containerName, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince, requestId, containerAcl).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(containerName, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince, requestId, containerAcl, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        return FluxUtil.withContext(context -> this.service.setAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, containerAclConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        return this.service.setAccessPolicyNoCustomHeaders(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, containerAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRestoreHeaders, Void>> restoreWithResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion) {
        String restype = "container";
        String comp = "undelete";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getUrl(), containerName, "container", "undelete", timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRestoreHeaders, Void>> restoreWithResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        String restype = "container";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restore(this.client.getUrl(), containerName, "container", "undelete", timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion) {
        return this.restoreWithResponseAsync(containerName, timeout, requestId, deletedContainerName, deletedContainerVersion).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        return this.restoreWithResponseAsync(containerName, timeout, requestId, deletedContainerName, deletedContainerVersion, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion) {
        String restype = "container";
        String comp = "undelete";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.restoreNoCustomHeaders(this.client.getUrl(), containerName, "container", "undelete", timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restoreNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        String restype = "container";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restoreNoCustomHeaders(this.client.getUrl(), containerName, "container", "undelete", timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenameHeaders, Void>> renameWithResponseAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId) {
        String restype = "container";
        String comp = "rename";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.rename(this.client.getUrl(), containerName, "container", "rename", timeout, this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenameHeaders, Void>> renameWithResponseAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        String restype = "container";
        String comp = "rename";
        String accept = "application/xml";
        return this.service.rename(this.client.getUrl(), containerName, "container", "rename", timeout, this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId) {
        return this.renameWithResponseAsync(containerName, sourceContainerName, timeout, requestId, sourceLeaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        return this.renameWithResponseAsync(containerName, sourceContainerName, timeout, requestId, sourceLeaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId) {
        String restype = "container";
        String comp = "rename";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.renameNoCustomHeaders(this.client.getUrl(), containerName, "container", "rename", timeout, this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNoCustomHeadersWithResponseAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        String restype = "container";
        String comp = "rename";
        String accept = "application/xml";
        return this.service.renameNoCustomHeaders(this.client.getUrl(), containerName, "container", "rename", timeout, this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatch(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout, requestId).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout, requestId, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatchNoCustomHeaders(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatch(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatchWithResponseAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        return this.submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout, requestId).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> submitBatchAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        return this.submitBatchWithResponseAsync(containerName, contentLength, multipartContentType, body, timeout, requestId, context).flatMapMany(fluxByteBufferResponse -> (Publisher)fluxByteBufferResponse.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.submitBatchNoCustomHeaders(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchNoCustomHeadersWithResponseAsync(String containerName, long contentLength, String multipartContentType, BinaryData body, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatchNoCustomHeaders(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults) {
        String restype = "container";
        String comp = "blobs";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.filterBlobs(this.client.getUrl(), containerName, "container", "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobsWithResponseAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults, Context context) {
        String restype = "container";
        String comp = "blobs";
        String accept = "application/xml";
        return this.service.filterBlobs(this.client.getUrl(), containerName, "container", "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults) {
        return this.filterBlobsWithResponseAsync(containerName, timeout, requestId, where, marker, maxresults).flatMap(res -> Mono.justOrEmpty((Object)((FilterBlobSegment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilterBlobSegment> filterBlobsAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults, Context context) {
        return this.filterBlobsWithResponseAsync(containerName, timeout, requestId, where, marker, maxresults, context).flatMap(res -> Mono.justOrEmpty((Object)((FilterBlobSegment)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults) {
        String restype = "container";
        String comp = "blobs";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.filterBlobsNoCustomHeaders(this.client.getUrl(), containerName, "container", "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults, Context context) {
        String restype = "container";
        String comp = "blobs";
        String accept = "application/xml";
        return this.service.filterBlobsNoCustomHeaders(this.client.getUrl(), containerName, "container", "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.acquireLease(this.client.getUrl(), containerName, "lease", "container", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(this.client.getUrl(), containerName, "lease", "container", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.acquireLeaseWithResponseAsync(containerName, timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.acquireLeaseWithResponseAsync(containerName, timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.acquireLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> acquireLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.releaseLease(this.client.getUrl(), containerName, "lease", "container", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(this.client.getUrl(), containerName, "lease", "container", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.releaseLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.releaseLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.releaseLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.renewLease(this.client.getUrl(), containerName, "lease", "container", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(this.client.getUrl(), containerName, "lease", "container", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.renewLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.renewLeaseWithResponseAsync(containerName, leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.renewLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renewLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.breakLease(this.client.getUrl(), containerName, "lease", "container", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(this.client.getUrl(), containerName, "lease", "container", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.breakLeaseWithResponseAsync(containerName, timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.breakLeaseWithResponseAsync(containerName, timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.breakLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseNoCustomHeadersWithResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.changeLease(this.client.getUrl(), containerName, "lease", "container", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(this.client.getUrl(), containerName, "lease", "container", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.changeLeaseWithResponseAsync(containerName, leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        return this.changeLeaseWithResponseAsync(containerName, leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return FluxUtil.withContext(context -> this.service.changeLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> changeLeaseNoCustomHeadersWithResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLeaseNoCustomHeaders(this.client.getUrl(), containerName, "lease", "container", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>> listBlobFlatSegmentWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobFlatSegment(this.client.getUrl(), containerName, "container", "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>> listBlobFlatSegmentWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listBlobFlatSegment(this.client.getUrl(), containerName, "container", "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobFlatSegmentWithResponseAsync(containerName, prefix, marker, maxresults, include, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsFlatSegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsFlatSegmentResponse> listBlobFlatSegmentAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        return this.listBlobFlatSegmentWithResponseAsync(containerName, prefix, marker, maxresults, include, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsFlatSegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeadersWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobFlatSegmentNoCustomHeaders(this.client.getUrl(), containerName, "container", "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeadersWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listBlobFlatSegmentNoCustomHeaders(this.client.getUrl(), containerName, "container", "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobHierarchySegment(this.client.getUrl(), containerName, "container", "list", prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentWithResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listBlobHierarchySegment(this.client.getUrl(), containerName, "container", "list", prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobHierarchySegmentWithResponseAsync(containerName, delimiter, prefix, marker, maxresults, include, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsHierarchySegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListBlobsHierarchySegmentResponse> listBlobHierarchySegmentAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        return this.listBlobHierarchySegmentWithResponseAsync(containerName, delimiter, prefix, marker, maxresults, include, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((ListBlobsHierarchySegmentResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listBlobHierarchySegmentNoCustomHeaders(this.client.getUrl(), containerName, "container", "list", prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeadersWithResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listBlobHierarchySegmentNoCustomHeaders(this.client.getUrl(), containerName, "container", "list", prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync(String containerName) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccountInfo(this.client.getUrl(), containerName, "account", "properties", this.client.getVersion(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>> getAccountInfoWithResponseAsync(String containerName, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfo(this.client.getUrl(), containerName, "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(String containerName) {
        return this.getAccountInfoWithResponseAsync(containerName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAccountInfoAsync(String containerName, Context context) {
        return this.getAccountInfoWithResponseAsync(containerName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(String containerName) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccountInfoNoCustomHeaders(this.client.getUrl(), containerName, "account", "properties", this.client.getVersion(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getAccountInfoNoCustomHeadersWithResponseAsync(String containerName, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfoNoCustomHeaders(this.client.getUrl(), containerName, "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageCont")
    public static interface ContainersService {
        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="x-ms-default-encryption-scope") String var9, @HeaderParam(value="x-ms-deny-encryption-scope-override") Boolean var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="x-ms-default-encryption-scope") String var9, @HeaderParam(value="x-ms-deny-encryption-scope-override") Boolean var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Delete(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersGetAccessPolicyHeaders, List<BlobSignedIdentifier>>> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<List<BlobSignedIdentifier>>> getAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @BodyParam(value="application/xml") SignedIdentifiersWrapper var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @BodyParam(value="application/xml") SignedIdentifiersWrapper var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersRestoreHeaders, Void>> restore(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-container-name") String var8, @HeaderParam(value="x-ms-deleted-container-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> restoreNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-container-name") String var8, @HeaderParam(value="x-ms-deleted-container-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersRenameHeaders, Void>> rename(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-source-container-name") String var8, @HeaderParam(value="x-ms-source-lease-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> renameNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-source-container-name") String var8, @HeaderParam(value="x-ms-source-lease-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-Type") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @BodyParam(value="application/xml") Flux<ByteBuffer> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-Type") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @BodyParam(value="application/xml") Flux<ByteBuffer> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersSubmitBatchHeaders, Flux<ByteBuffer>>> submitBatch(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-Type") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @BodyParam(value="application/xml") BinaryData var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Post(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> submitBatchNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-Type") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @BodyParam(value="application/xml") BinaryData var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersFilterBlobsHeaders, FilterBlobSegment>> filterBlobs(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="where") String var8, @QueryParam(value="marker") String var9, @QueryParam(value="maxresults") Integer var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<FilterBlobSegment>> filterBlobsNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="where") String var8, @QueryParam(value="marker") String var9, @QueryParam(value="maxresults") Integer var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersAcquireLeaseHeaders, Void>> acquireLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> acquireLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersReleaseLeaseHeaders, Void>> releaseLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> releaseLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersRenewLeaseHeaders, Void>> renewLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> renewLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersBreakLeaseHeaders, Void>> breakLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> breakLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersChangeLeaseHeaders, Void>> changeLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> changeLeaseNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>> listBlobFlatSegment(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="marker") String var6, @QueryParam(value="maxresults") Integer var7, @QueryParam(value="include") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<ListBlobsFlatSegmentResponse>> listBlobFlatSegmentNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="marker") String var6, @QueryParam(value="maxresults") Integer var7, @QueryParam(value="include") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobHierarchySegment(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<ListBlobsHierarchySegmentResponse>> listBlobHierarchySegmentNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<ContainersGetAccountInfoHeaders, Void>> getAccountInfo(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<Response<Void>> getAccountInfoNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

