/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.utils;

import java.util.Collection;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.tasks.TaskCancelledException;

public final class ExceptionRootCauseFinder {
    static final Set<RestStatus> IRRECOVERABLE_REST_STATUSES = Set.of(RestStatus.GONE, RestStatus.NOT_IMPLEMENTED, RestStatus.NOT_FOUND, RestStatus.BAD_REQUEST, RestStatus.UNAUTHORIZED, RestStatus.FORBIDDEN, RestStatus.METHOD_NOT_ALLOWED, RestStatus.NOT_ACCEPTABLE);

    public static String getDetailedMessage(Throwable t) {
        if (t instanceof ElasticsearchException) {
            return ((ElasticsearchException)t).getDetailedMessage();
        }
        return t.getMessage();
    }

    public static Throwable getFirstIrrecoverableExceptionFromBulkResponses(Collection<BulkItemResponse> failures) {
        for (BulkItemResponse failure : failures) {
            ElasticsearchException elasticsearchException;
            Throwable unwrappedThrowable = ExceptionsHelper.unwrapCause((Throwable)failure.getFailure().getCause());
            if (unwrappedThrowable instanceof IllegalArgumentException) {
                return unwrappedThrowable;
            }
            if (!(unwrappedThrowable instanceof ElasticsearchException) || !ExceptionRootCauseFinder.isExceptionIrrecoverable(elasticsearchException = (ElasticsearchException)unwrappedThrowable)) continue;
            return elasticsearchException;
        }
        return null;
    }

    public static boolean isExceptionIrrecoverable(ElasticsearchException elasticsearchException) {
        if (IRRECOVERABLE_REST_STATUSES.contains(elasticsearchException.status())) {
            if (elasticsearchException instanceof TaskCancelledException) {
                return false;
            }
            return !(elasticsearchException instanceof SearchContextMissingException);
        }
        return false;
    }

    private ExceptionRootCauseFinder() {
    }
}

