/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiling.InstanceType;

final class HostMetadata
implements ToXContentObject {
    final String hostID;
    final InstanceType instanceType;
    final String profilingHostMachine;

    HostMetadata(String hostID, InstanceType instanceType, String profilingHostMachine) {
        this.hostID = hostID;
        this.instanceType = instanceType;
        this.profilingHostMachine = profilingHostMachine;
    }

    public static HostMetadata fromSource(Map<String, Object> source) {
        if (source != null) {
            String hostID = (String)source.get("host.id");
            String profilingHostMachine = (String)source.get("profiling.host.machine");
            return new HostMetadata(hostID, InstanceType.fromHostSource(source), profilingHostMachine);
        }
        return new HostMetadata("", new InstanceType("", "", ""), "");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.instanceType.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMetadata that = (HostMetadata)o;
        return Objects.equals(this.hostID, that.hostID);
    }

    public int hashCode() {
        return Objects.hash(this.hostID);
    }
}

