/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteria;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;
import org.elasticsearch.xpack.application.rules.QueryRulesConfig;
import org.elasticsearch.xpack.application.rules.QueryRuleset;
import org.elasticsearch.xpack.application.rules.QueryRulesetListItem;

public class QueryRulesIndexService {
    private static final Logger logger = LogManager.getLogger(QueryRulesIndexService.class);
    public static final String QUERY_RULES_ALIAS_NAME = ".query-rules";
    public static final String QUERY_RULES_CONCRETE_INDEX_NAME = ".query-rules-1";
    public static final String QUERY_RULES_INDEX_NAME_PATTERN = ".query-rules-*";
    private static final int QUERY_RULES_INDEX_MAPPINGS_VERSION = 1;
    private final Client clientWithOrigin;
    private final ClusterSettings clusterSettings;

    public QueryRulesIndexService(Client client, ClusterSettings clusterSettings) {
        this.clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
        this.clusterSettings = clusterSettings;
    }

    public static SystemIndexDescriptor getSystemIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(QUERY_RULES_INDEX_NAME_PATTERN).setPrimaryIndex(QUERY_RULES_CONCRETE_INDEX_NAME).setDescription("Contains query ruleset configuration for query rules").setMappings(QueryRulesIndexService.getIndexMappings()).setSettings(QueryRulesIndexService.getIndexSettings()).setAliasName(QUERY_RULES_ALIAS_NAME).setVersionMetaKey("version").setOrigin("enterprise_search").setThreadPools(ExecutorNames.DEFAULT_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private static Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").put("index.priority", 100).put("index.refresh_interval", "1s").build();
    }

    private static XContentBuilder getIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("version", Version.CURRENT.toString());
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject(QueryRuleset.ID_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(QueryRuleset.RULES_FIELD.getPreferredName());
            builder.startObject("properties");
            builder.startObject(QueryRule.ID_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(QueryRule.TYPE_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(QueryRule.CRITERIA_FIELD.getPreferredName());
            builder.startObject("properties");
            builder.startObject(QueryRuleCriteria.TYPE_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(QueryRuleCriteria.METADATA_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(QueryRuleCriteria.VALUES_FIELD.getPreferredName());
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.startObject(QueryRule.ACTIONS_FIELD.getPreferredName());
            builder.field("type", "object");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            logger.fatal("Failed to build .query-rules-1 index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build .query-rules-1 index mappings", e);
        }
    }

    public void getQueryRuleset(final String resourceName, final ActionListener<QueryRuleset> listener) {
        GetRequest getRequest = new GetRequest(QUERY_RULES_ALIAS_NAME).id(resourceName).realtime(true);
        this.clientWithOrigin.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (!getResponse.isExists()) {
                    listener.onFailure((Exception)new ResourceNotFoundException(resourceName, new Object[0]));
                    return;
                }
                Map source = getResponse.getSource();
                List<QueryRule> rules = ((List)source.get(QueryRuleset.RULES_FIELD.getPreferredName())).stream().map(rule -> new QueryRule((String)rule.get(QueryRule.ID_FIELD.getPreferredName()), QueryRule.QueryRuleType.queryRuleType((String)rule.get(QueryRule.TYPE_FIELD.getPreferredName())), QueryRulesIndexService.parseCriteria((List)rule.get(QueryRule.CRITERIA_FIELD.getPreferredName())), (Map)rule.get(QueryRule.ACTIONS_FIELD.getPreferredName()))).collect(Collectors.toList());
                QueryRuleset res = new QueryRuleset(resourceName, rules);
                listener.onResponse((Object)res);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException(resourceName, new Object[0]));
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    private static List<QueryRuleCriteria> parseCriteria(List<Map<String, Object>> rawCriteria) {
        ArrayList<QueryRuleCriteria> criteria = new ArrayList<QueryRuleCriteria>(rawCriteria.size());
        for (Map<String, Object> entry : rawCriteria) {
            criteria.add(new QueryRuleCriteria(QueryRuleCriteriaType.type((String)entry.get(QueryRuleCriteria.TYPE_FIELD.getPreferredName())), (String)entry.get(QueryRuleCriteria.METADATA_FIELD.getPreferredName()), (List)entry.get(QueryRuleCriteria.VALUES_FIELD.getPreferredName())));
        }
        return criteria;
    }

    public void putQueryRuleset(QueryRuleset queryRuleset, ActionListener<DocWriteResponse> listener) {
        try {
            this.validateQueryRuleset(queryRuleset);
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(QUERY_RULES_ALIAS_NAME).opType(DocWriteRequest.OpType.INDEX).id(queryRuleset.id()).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(queryRuleset.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
            this.clientWithOrigin.index(indexRequest, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void validateQueryRuleset(QueryRuleset queryRuleset) {
        Setting maxRuleLimitSetting = this.clusterSettings.get(QueryRulesConfig.MAX_RULE_LIMIT_SETTING.getKey());
        int maxRuleLimit = (Integer)this.clusterSettings.get(Objects.requireNonNull(maxRuleLimitSetting));
        if (queryRuleset.rules().size() > maxRuleLimit) {
            throw new IllegalArgumentException("The number of rules in a ruleset cannot exceed [" + maxRuleLimit + "].This maximum can be set by changing the [" + QueryRulesConfig.MAX_RULE_LIMIT_SETTING.getKey() + "] setting.");
        }
    }

    public void deleteQueryRuleset(final String resourceName, final ActionListener<DeleteResponse> listener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(QUERY_RULES_ALIAS_NAME).id(resourceName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.clientWithOrigin.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    listener.onFailure((Exception)new ResourceNotFoundException(resourceName, new Object[0]));
                    return;
                }
                listener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException(resourceName, new Object[0]));
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    public void listQueryRulesets(int from, int size, final ActionListener<QueryRulesetResult> listener) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().from(from).size(size).query((QueryBuilder)new MatchAllQueryBuilder()).fetchSource(new String[]{QueryRuleset.ID_FIELD.getPreferredName(), QueryRuleset.RULES_FIELD.getPreferredName(), QueryRuleset.RULES_FIELD.getPreferredName() + "." + QueryRule.TYPE_FIELD.getPreferredName()}, null).sort(QueryRuleset.ID_FIELD.getPreferredName(), SortOrder.ASC);
            SearchRequest req = new SearchRequest(new String[]{QUERY_RULES_ALIAS_NAME}).source(source);
            this.clientWithOrigin.search(req, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    listener.onResponse((Object)QueryRulesIndexService.mapSearchResponseToQueryRulesetList(searchResponse));
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new QueryRulesetResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static QueryRulesetResult mapSearchResponseToQueryRulesetList(SearchResponse response) {
        List<QueryRulesetListItem> rulesetResults = Arrays.stream(response.getHits().getHits()).map(QueryRulesIndexService::hitToQueryRulesetListItem).toList();
        return new QueryRulesetResult(rulesetResults, (int)response.getHits().getTotalHits().value);
    }

    private static QueryRulesetListItem hitToQueryRulesetListItem(SearchHit searchHit) {
        Map sourceMap = searchHit.getSourceAsMap();
        String rulesetId = (String)sourceMap.get(QueryRuleset.ID_FIELD.getPreferredName());
        List rules = (List)sourceMap.get(QueryRuleset.RULES_FIELD.getPreferredName());
        int numRules = rules.size();
        HashMap<QueryRuleCriteriaType, Integer> queryRuleCriteriaTypeToCountMap = new HashMap<QueryRuleCriteriaType, Integer>();
        for (LinkedHashMap rule : rules) {
            List criteriaList = (List)rule.get(QueryRule.CRITERIA_FIELD.getPreferredName());
            for (LinkedHashMap criteria : criteriaList) {
                String criteriaType = (String)criteria.get(QueryRuleCriteria.TYPE_FIELD.getPreferredName());
                QueryRuleCriteriaType queryRuleCriteriaType = QueryRuleCriteriaType.type(criteriaType);
                queryRuleCriteriaTypeToCountMap.compute(queryRuleCriteriaType, (k, v) -> v == null ? 1 : v + 1);
            }
        }
        return new QueryRulesetListItem(rulesetId, numRules, queryRuleCriteriaTypeToCountMap);
    }

    public record QueryRulesetResult(List<QueryRulesetListItem> rulesets, long totalResults) {
    }
}

