/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public class ListConnectorSyncJobsAction
extends ActionType<Response> {
    public static final ListConnectorSyncJobsAction INSTANCE = new ListConnectorSyncJobsAction();
    public static final String NAME = "cluster:admin/xpack/connector/sync_job/list";

    public ListConnectorSyncJobsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField RESULTS_FIELD = new ParseField("results", new String[0]);
        final QueryPage<ConnectorSyncJob> queryPage;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.queryPage = new QueryPage(in, ConnectorSyncJob::new);
        }

        public Response(List<ConnectorSyncJob> items, Long totalResults) {
            this.queryPage = new QueryPage(items, totalResults.longValue(), RESULTS_FIELD);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryPage.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryPage.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.queryPage, response.queryPage);
        }

        public int hashCode() {
            return Objects.hash(this.queryPage);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField CONNECTOR_ID_FIELD = new ParseField("connector_id", new String[0]);
        private static final ParseField PAGE_PARAMS_FIELD = new ParseField("pageParams", new String[0]);
        private final PageParams pageParams;
        private final String connectorId;
        private final ConnectorSyncStatus connectorSyncStatus;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("list_connector_sync_jobs_request", p -> new Request((PageParams)p[0], (String)p[1], p[2] != null ? ConnectorSyncStatus.fromString((String)p[2]) : null));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.pageParams = new PageParams(in);
            this.connectorId = in.readOptionalString();
            this.connectorSyncStatus = (ConnectorSyncStatus)in.readOptionalEnum(ConnectorSyncStatus.class);
        }

        public Request(PageParams pageParams, String connectorId, ConnectorSyncStatus connectorSyncStatus) {
            this.pageParams = pageParams;
            this.connectorId = connectorId;
            this.connectorSyncStatus = connectorSyncStatus;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorSyncStatus getConnectorSyncStatus() {
            return this.connectorSyncStatus;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.pageParams.writeTo(out);
            out.writeOptionalString(this.connectorId);
            out.writeOptionalEnum((Enum)this.connectorSyncStatus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.pageParams, request.pageParams) && Objects.equals(this.connectorId, request.connectorId) && this.connectorSyncStatus == request.connectorSyncStatus;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.pageParams, this.connectorId, this.connectorSyncStatus});
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PAGE_PARAMS_FIELD.getPreferredName(), (ToXContent)this.pageParams);
            builder.field(CONNECTOR_ID_FIELD.getPreferredName(), this.connectorId);
            builder.field(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), (Enum)this.connectorSyncStatus);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PageParams.fromXContent((XContentParser)p), PAGE_PARAMS_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CONNECTOR_ID_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncJob.STATUS_FIELD);
        }
    }
}

