/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobTriggerMethod;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;
import org.elasticsearch.xpack.application.connector.syncjob.action.PostConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.UpdateConnectorSyncJobIngestionStatsAction;

public class ConnectorSyncJobIndexService {
    private static final Long ZERO = 0L;
    private final Client clientWithOrigin;
    public static final String CONNECTOR_SYNC_JOB_INDEX_NAME = ".elastic-connectors-sync-jobs-v1";

    public ConnectorSyncJobIndexService(Client client) {
        this.clientWithOrigin = new OriginSettingClient(client, "connectors");
    }

    public void createConnectorSyncJob(PostConnectorSyncJobAction.Request request, ActionListener<PostConnectorSyncJobAction.Response> listener) {
        try {
            this.getSyncJobConnectorInfo(request.getId(), (ActionListener<Connector>)listener.delegateFailure((l, connector) -> {
                Instant now = Instant.now();
                ConnectorSyncJobType jobType = Objects.requireNonNullElse(request.getJobType(), ConnectorSyncJob.DEFAULT_JOB_TYPE);
                ConnectorSyncJobTriggerMethod triggerMethod = Objects.requireNonNullElse(request.getTriggerMethod(), ConnectorSyncJob.DEFAULT_TRIGGER_METHOD);
                try {
                    String syncJobId = this.generateId();
                    IndexRequest indexRequest = (IndexRequest)new IndexRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).id(syncJobId).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    ConnectorSyncJob syncJob = new ConnectorSyncJob.Builder().setId(syncJobId).setJobType(jobType).setTriggerMethod(triggerMethod).setStatus(ConnectorSyncJob.DEFAULT_INITIAL_STATUS).setConnector((Connector)connector).setCreatedAt(now).setLastSeen(now).setTotalDocumentCount(ZERO).setIndexedDocumentCount(ZERO).setIndexedDocumentVolume(ZERO).setDeletedDocumentCount(ZERO).build();
                    indexRequest.source(syncJob.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
                    this.clientWithOrigin.index(indexRequest, l.delegateFailureAndWrap((ll, indexResponse) -> ll.onResponse((Object)new PostConnectorSyncJobAction.Response(indexResponse.getId()))));
                }
                catch (IOException e) {
                    l.onFailure((Exception)e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteConnectorSyncJob(String connectorSyncJobId, ActionListener<DeleteResponse> listener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).id(connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.clientWithOrigin.delete(deleteRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<DeleteResponse, DeleteResponse>(connectorSyncJobId, listener, (l, deleteResponse) -> {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorSyncJobId, new Object[0]));
                    return;
                }
                l.onResponse(deleteResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void checkInConnectorSyncJob(String connectorSyncJobId, ActionListener<UpdateResponse> listener) {
        Instant newLastSeen = Instant.now();
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(Map.of(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), newLastSeen));
        try {
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(connectorSyncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorSyncJobId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void getConnectorSyncJob(String connectorSyncJobId, ActionListener<ConnectorSyncJob> listener) {
        GetRequest getRequest = new GetRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).id(connectorSyncJobId).realtime(true);
        try {
            this.clientWithOrigin.get(getRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<GetResponse, ConnectorSyncJob>(connectorSyncJobId, listener, (l, getResponse) -> {
                if (!getResponse.isExists()) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorSyncJobId, new Object[0]));
                    return;
                }
                try {
                    ConnectorSyncJob syncJob = ConnectorSyncJob.fromXContentBytes(getResponse.getSourceAsBytesRef(), XContentType.JSON);
                    l.onResponse((Object)syncJob);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void cancelConnectorSyncJob(String connectorSyncJobId, ActionListener<UpdateResponse> listener) {
        Instant cancellationRequestedAt = Instant.now();
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(Map.of(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), ConnectorSyncStatus.CANCELING, ConnectorSyncJob.CANCELATION_REQUESTED_AT_FIELD.getPreferredName(), cancellationRequestedAt));
        try {
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(connectorSyncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorSyncJobId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void listConnectorSyncJobs(int from, int size, String connectorId, ConnectorSyncStatus syncStatus, final ActionListener<ConnectorSyncJobsResult> listener) {
        try {
            QueryBuilder query = ConnectorSyncJobIndexService.buildListQuery(connectorId, syncStatus);
            SearchSourceBuilder searchSource = new SearchSourceBuilder().from(from).size(size).query(query).fetchSource(true).sort(ConnectorSyncJob.CREATED_AT_FIELD.getPreferredName(), SortOrder.ASC);
            SearchRequest searchRequest = new SearchRequest(new String[]{CONNECTOR_SYNC_JOB_INDEX_NAME}).source(searchSource);
            this.clientWithOrigin.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        listener.onResponse((Object)ConnectorSyncJobIndexService.this.mapSearchResponseToConnectorSyncJobsList(searchResponse));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new ConnectorSyncJobsResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static QueryBuilder buildListQuery(String connectorId, ConnectorSyncStatus syncStatus) {
        boolean usesFilter = Stream.of(new Serializable[]{connectorId, syncStatus}).anyMatch(x$0 -> Objects.nonNull(x$0));
        BoolQueryBuilder boolFilterQueryBuilder = new BoolQueryBuilder();
        if (usesFilter) {
            if (Objects.nonNull(connectorId)) {
                TermQueryBuilder connectorIdQuery = new TermQueryBuilder(ConnectorSyncJob.CONNECTOR_FIELD.getPreferredName() + "." + Connector.ID_FIELD.getPreferredName(), connectorId);
                boolFilterQueryBuilder.must().add(connectorIdQuery);
            }
            if (Objects.nonNull((Object)syncStatus)) {
                TermQueryBuilder syncStatusQuery = new TermQueryBuilder(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), (Object)syncStatus);
                boolFilterQueryBuilder.must().add(syncStatusQuery);
            }
        }
        return usesFilter ? boolFilterQueryBuilder : new MatchAllQueryBuilder();
    }

    private ConnectorSyncJobsResult mapSearchResponseToConnectorSyncJobsList(SearchResponse searchResponse) {
        List<ConnectorSyncJob> connectorSyncJobs = Arrays.stream(searchResponse.getHits().getHits()).map(ConnectorSyncJobIndexService::hitToConnectorSyncJob).toList();
        return new ConnectorSyncJobsResult(connectorSyncJobs, (int)searchResponse.getHits().getTotalHits().value);
    }

    private static ConnectorSyncJob hitToConnectorSyncJob(SearchHit searchHit) {
        return ConnectorSyncJob.fromXContentBytes(searchHit.getSourceRef(), XContentType.JSON);
    }

    public void updateConnectorSyncJobIngestionStats(UpdateConnectorSyncJobIngestionStatsAction.Request request, ActionListener<UpdateResponse> listener) {
        String syncJobId = request.getConnectorSyncJobId();
        HashMap<String, Long> fieldsToUpdate = new HashMap<String, Long>(Map.of(ConnectorSyncJob.DELETED_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getDeletedDocumentCount(), ConnectorSyncJob.INDEXED_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getIndexedDocumentCount(), ConnectorSyncJob.INDEXED_DOCUMENT_VOLUME_FIELD.getPreferredName(), request.getIndexedDocumentVolume()));
        if (Objects.nonNull(request.getTotalDocumentCount())) {
            fieldsToUpdate.put(ConnectorSyncJob.TOTAL_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getTotalDocumentCount());
        }
        Instant lastSeen = Objects.nonNull(request.getLastSeen()) ? request.getLastSeen() : Instant.now();
        fieldsToUpdate.put(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), (Long)((Object)lastSeen));
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, syncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(fieldsToUpdate);
        try {
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(syncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(syncJobId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private String generateId() {
        return UUIDs.base64UUID();
    }

    private void getSyncJobConnectorInfo(final String connectorId, final ActionListener<Connector> listener) {
        try {
            GetRequest request = new GetRequest(".elastic-connectors-v1", connectorId);
            this.clientWithOrigin.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    boolean connectorDoesNotExist;
                    boolean bl = connectorDoesNotExist = !response.isExists();
                    if (connectorDoesNotExist) {
                        this.onFailure((Exception)new ResourceNotFoundException("Connector with id '" + connectorId + "' does not exist.", new Object[0]));
                        return;
                    }
                    try {
                        Connector connector = Connector.fromXContentBytes(response.getSourceAsBytesRef(), connectorId, XContentType.JSON);
                        Connector syncJobConnector = new Connector.Builder().setConnectorId(connector.getConnectorId()).setFiltering(null).setSyncJobFiltering(ConnectorSyncJobIndexService.this.transformConnectorFilteringToSyncJobRepresentation(connector.getFiltering())).setIndexName(connector.getIndexName()).setLanguage(connector.getLanguage()).setPipeline(connector.getPipeline()).setServiceType(connector.getServiceType()).setConfiguration(connector.getConfiguration()).build();
                        listener.onResponse((Object)syncJobConnector);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    FilteringRules transformConnectorFilteringToSyncJobRepresentation(List<ConnectorFiltering> connectorFiltering) {
        return Optional.ofNullable(connectorFiltering).filter(list -> !list.isEmpty()).map(list -> ((ConnectorFiltering)list.get(0)).getActive()).orElse(null);
    }

    public void updateConnectorSyncJobError(String connectorSyncJobId, String error, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(Map.of(ConnectorSyncJob.ERROR_FIELD.getPreferredName(), error, ConnectorSyncJob.STATUS_FIELD.getPreferredName(), ConnectorSyncStatus.ERROR));
        try {
            this.clientWithOrigin.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(connectorSyncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)new ResourceNotFoundException(connectorSyncJobId, new Object[0]));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    static class DelegatingIndexNotFoundOrDocumentMissingActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String connectorSyncJobId;

        DelegatingIndexNotFoundOrDocumentMissingActionListener(String connectorSyncJobId, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.connectorSyncJobId = connectorSyncJobId;
        }

        public void onResponse(T t) {
            this.bc.accept((ActionListener<R>)this.delegate, (ActionListener)t);
        }

        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException || cause instanceof DocumentMissingException) {
                this.delegate.onFailure((Exception)new ResourceNotFoundException("connector sync job [" + this.connectorSyncJobId + "] not found", new Object[0]));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public record ConnectorSyncJobsResult(List<ConnectorSyncJob> connectorSyncJobs, long totalResults) {
    }
}

