/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorIndexService;
import org.elasticsearch.xpack.application.connector.action.PutConnectorAction;

public class TransportPutConnectorAction
extends HandledTransportAction<PutConnectorAction.Request, PutConnectorAction.Response> {
    protected final ConnectorIndexService connectorIndexService;

    @Inject
    public TransportPutConnectorAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/connector/put", transportService, actionFilters, PutConnectorAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorIndexService = new ConnectorIndexService(client);
    }

    protected void doExecute(Task task, PutConnectorAction.Request request, ActionListener<PutConnectorAction.Response> listener) {
        Boolean isNative = Objects.requireNonNullElse(request.getIsNative(), false);
        Connector connector = new Connector.Builder().setDescription(request.getDescription()).setIndexName(request.getIndexName()).setIsNative(isNative).setLanguage(request.getLanguage()).setName(request.getName()).setServiceType(request.getServiceType()).build();
        this.connectorIndexService.putConnector(request.getConnectorId(), connector, (ActionListener<DocWriteResponse>)listener.map(r -> new PutConnectorAction.Response(r.getResult())));
    }
}

