/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DeleteConnectorAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteConnectorAction INSTANCE = new DeleteConnectorAction();
    public static final String NAME = "cluster:admin/xpack/connector/delete";

    private DeleteConnectorAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private static final ParseField CONNECTOR_ID_FIELD = new ParseField("connector_id", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("delete_connector_request", false, p -> new Request((String)p[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
        }

        public Request(String connectorId) {
            this.connectorId = connectorId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"connector_id missing", validationException);
            }
            return validationException;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CONNECTOR_ID_FIELD.getPreferredName(), this.connectorId);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CONNECTOR_ID_FIELD);
        }
    }
}

