/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.configuration.ConfigurationDependency;
import org.elasticsearch.xpack.application.connector.configuration.ConfigurationDisplayType;
import org.elasticsearch.xpack.application.connector.configuration.ConfigurationFieldType;
import org.elasticsearch.xpack.application.connector.configuration.ConfigurationSelectOption;
import org.elasticsearch.xpack.application.connector.configuration.ConfigurationValidation;

public class ConnectorConfiguration
implements Writeable,
ToXContentObject {
    @Nullable
    private final String category;
    private final Object defaultValue;
    private final List<ConfigurationDependency> dependsOn;
    private final ConfigurationDisplayType display;
    private final String label;
    private final List<ConfigurationSelectOption> options;
    @Nullable
    private final Integer order;
    @Nullable
    private final String placeholder;
    private final boolean required;
    private final boolean sensitive;
    @Nullable
    private final String tooltip;
    private final ConfigurationFieldType type;
    private final List<String> uiRestrictions;
    private final List<ConfigurationValidation> validations;
    private final Object value;
    static final ParseField CATEGORY_FIELD = new ParseField("category", new String[0]);
    static final ParseField DEFAULT_VALUE_FIELD = new ParseField("default_value", new String[0]);
    static final ParseField DEPENDS_ON_FIELD = new ParseField("depends_on", new String[0]);
    static final ParseField DISPLAY_FIELD = new ParseField("display", new String[0]);
    static final ParseField LABEL_FIELD = new ParseField("label", new String[0]);
    static final ParseField OPTIONS_FIELD = new ParseField("options", new String[0]);
    static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    static final ParseField PLACEHOLDER_FIELD = new ParseField("placeholder", new String[0]);
    static final ParseField REQUIRED_FIELD = new ParseField("required", new String[0]);
    static final ParseField SENSITIVE_FIELD = new ParseField("sensitive", new String[0]);
    static final ParseField TOOLTIP_FIELD = new ParseField("tooltip", new String[0]);
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    static final ParseField UI_RESTRICTIONS_FIELD = new ParseField("ui_restrictions", new String[0]);
    static final ParseField VALIDATIONS_FIELD = new ParseField("validations", new String[0]);
    static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ConstructingObjectParser<ConnectorConfiguration, Void> PARSER = new ConstructingObjectParser("connector_configuration_dependency", true, args -> {
        int i = 0;
        return new Builder().setCategory((String)args[i++]).setDefaultValue(args[i++]).setDependsOn((List)args[i++]).setDisplay((ConfigurationDisplayType)((Object)((Object)args[i++]))).setLabel((String)args[i++]).setOptions((List)args[i++]).setOrder((Integer)args[i++]).setPlaceholder((String)args[i++]).setRequired((Boolean)args[i++]).setSensitive((Boolean)args[i++]).setTooltip((String)args[i++]).setType((ConfigurationFieldType)((Object)((Object)args[i++]))).setUiRestrictions((List)args[i++]).setValidations((List)args[i++]).setValue(args[i]).build();
    });

    private ConnectorConfiguration(String category, Object defaultValue, List<ConfigurationDependency> dependsOn, ConfigurationDisplayType display, String label, List<ConfigurationSelectOption> options, Integer order, String placeholder, boolean required, boolean sensitive, String tooltip, ConfigurationFieldType type, List<String> uiRestrictions, List<ConfigurationValidation> validations, Object value) {
        this.category = category;
        this.defaultValue = defaultValue;
        this.dependsOn = dependsOn;
        this.display = display;
        this.label = label;
        this.options = options;
        this.order = order;
        this.placeholder = placeholder;
        this.required = required;
        this.sensitive = sensitive;
        this.tooltip = tooltip;
        this.type = type;
        this.uiRestrictions = uiRestrictions;
        this.validations = validations;
        this.value = value;
    }

    public ConnectorConfiguration(StreamInput in) throws IOException {
        this.category = in.readString();
        this.defaultValue = in.readGenericValue();
        this.dependsOn = in.readOptionalCollectionAsList(ConfigurationDependency::new);
        this.display = (ConfigurationDisplayType)in.readEnum(ConfigurationDisplayType.class);
        this.label = in.readString();
        this.options = in.readOptionalCollectionAsList(ConfigurationSelectOption::new);
        this.order = in.readOptionalInt();
        this.placeholder = in.readOptionalString();
        this.required = in.readBoolean();
        this.sensitive = in.readBoolean();
        this.tooltip = in.readOptionalString();
        this.type = (ConfigurationFieldType)in.readEnum(ConfigurationFieldType.class);
        this.uiRestrictions = in.readOptionalStringCollectionAsList();
        this.validations = in.readOptionalCollectionAsList(ConfigurationValidation::new);
        this.value = in.readGenericValue();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.category != null) {
            builder.field(CATEGORY_FIELD.getPreferredName(), this.category);
        }
        builder.field(DEFAULT_VALUE_FIELD.getPreferredName(), this.defaultValue);
        if (this.dependsOn != null) {
            builder.xContentList(DEPENDS_ON_FIELD.getPreferredName(), this.dependsOn);
        }
        if (this.display != null) {
            builder.field(DISPLAY_FIELD.getPreferredName(), this.display.toString());
        }
        builder.field(LABEL_FIELD.getPreferredName(), this.label);
        if (this.options != null) {
            builder.xContentList(OPTIONS_FIELD.getPreferredName(), this.options);
        }
        if (this.order != null) {
            builder.field(ORDER_FIELD.getPreferredName(), this.order);
        }
        if (this.placeholder != null) {
            builder.field(PLACEHOLDER_FIELD.getPreferredName(), this.placeholder);
        }
        builder.field(REQUIRED_FIELD.getPreferredName(), this.required);
        builder.field(SENSITIVE_FIELD.getPreferredName(), this.sensitive);
        if (this.tooltip != null) {
            builder.field(TOOLTIP_FIELD.getPreferredName(), this.tooltip);
        }
        if (this.type != null) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString());
        }
        if (this.uiRestrictions != null) {
            builder.stringListField(UI_RESTRICTIONS_FIELD.getPreferredName(), this.uiRestrictions);
        }
        if (this.validations != null) {
            builder.xContentList(VALIDATIONS_FIELD.getPreferredName(), this.validations);
        }
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public static ConnectorConfiguration fromXContent(XContentParser parser) throws IOException {
        return (ConnectorConfiguration)PARSER.parse(parser, null);
    }

    public static ConnectorConfiguration fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorConfiguration connectorConfiguration;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorConfiguration = ConnectorConfiguration.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector configuration field.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorConfiguration;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.category);
        out.writeGenericValue(this.defaultValue);
        out.writeOptionalCollection(this.dependsOn);
        out.writeEnum((Enum)this.display);
        out.writeString(this.label);
        out.writeOptionalCollection(this.options);
        out.writeOptionalInt(this.order);
        out.writeOptionalString(this.placeholder);
        out.writeBoolean(this.required);
        out.writeBoolean(this.sensitive);
        out.writeOptionalString(this.tooltip);
        out.writeEnum((Enum)this.type);
        out.writeOptionalStringCollection(this.uiRestrictions);
        out.writeOptionalCollection(this.validations);
        out.writeGenericValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorConfiguration that = (ConnectorConfiguration)o;
        return this.required == that.required && this.sensitive == that.sensitive && Objects.equals(this.category, that.category) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.dependsOn, that.dependsOn) && this.display == that.display && Objects.equals(this.label, that.label) && Objects.equals(this.options, that.options) && Objects.equals(this.order, that.order) && Objects.equals(this.placeholder, that.placeholder) && Objects.equals(this.tooltip, that.tooltip) && this.type == that.type && Objects.equals(this.uiRestrictions, that.uiRestrictions) && Objects.equals(this.validations, that.validations) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.defaultValue, this.dependsOn, this.display, this.label, this.options, this.order, this.placeholder, this.required, this.sensitive, this.tooltip, this.type, this.uiRestrictions, this.validations, this.value});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), CATEGORY_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return Boolean.valueOf(p.booleanValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, DEFAULT_VALUE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConfigurationDependency.fromXContent(p), DEPENDS_ON_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConfigurationDisplayType.displayType(p.text()), DISPLAY_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), LABEL_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConfigurationSelectOption.fromXContent(p), OPTIONS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), ORDER_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), PLACEHOLDER_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REQUIRED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SENSITIVE_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), TOOLTIP_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConfigurationFieldType.fieldType(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), UI_RESTRICTIONS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConfigurationValidation.fromXContent(p), VALIDATIONS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return p.text();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.numberValue();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                return p.booleanValue();
            }
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                return p.map();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
        }, VALUE_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
    }

    public static class Builder {
        private String category;
        private Object defaultValue;
        private List<ConfigurationDependency> dependsOn;
        private ConfigurationDisplayType display;
        private String label;
        private List<ConfigurationSelectOption> options;
        private Integer order;
        private String placeholder;
        private boolean required;
        private boolean sensitive;
        private String tooltip;
        private ConfigurationFieldType type;
        private List<String> uiRestrictions;
        private List<ConfigurationValidation> validations;
        private Object value;

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setDependsOn(List<ConfigurationDependency> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public Builder setDisplay(ConfigurationDisplayType display) {
            this.display = display;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setOptions(List<ConfigurationSelectOption> options) {
            this.options = options;
            return this;
        }

        public Builder setOrder(Integer order) {
            this.order = order;
            return this;
        }

        public Builder setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder setRequired(Boolean required) {
            this.required = Objects.requireNonNullElse(required, false);
            return this;
        }

        public Builder setSensitive(Boolean sensitive) {
            this.sensitive = Objects.requireNonNullElse(sensitive, false);
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setType(ConfigurationFieldType type) {
            this.type = type;
            return this;
        }

        public Builder setUiRestrictions(List<String> uiRestrictions) {
            this.uiRestrictions = uiRestrictions;
            return this;
        }

        public Builder setValidations(List<ConfigurationValidation> validations) {
            this.validations = validations;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public ConnectorConfiguration build() {
            return new ConnectorConfiguration(this.category, this.defaultValue, this.dependsOn, this.display, this.label, this.options, this.order, this.placeholder, this.required, this.sensitive, this.tooltip, this.type, this.uiRestrictions, this.validations, this.value);
        }
    }
}

