/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseCacheManagement;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutLifecycleAction.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry namedXContentRegistry, XPackLicenseState licenseState, Client client) {
        super("cluster:admin/ilm/put", transportService, clusterService, threadPool, actionFilters, PutLifecycleAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.xContentRegistry = namedXContentRegistry;
        this.licenseState = licenseState;
        this.client = client;
    }

    protected void masterOperation(Task task, PutLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)state);
        LifecyclePolicy.validatePolicyName((String)request.getPolicy().getName());
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle", (Metadata.Custom)IndexLifecycleMetadata.EMPTY);
        LifecyclePolicyMetadata existingPolicy = (LifecyclePolicyMetadata)lifecycleMetadata.getPolicyMetadatas().get(request.getPolicy().getName());
        if (TransportPutLifecycleAction.isNoopUpdate(existingPolicy, request.getPolicy(), filteredHeaders)) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        this.submitUnbatchedTask("put-lifecycle-" + request.getPolicy().getName(), (ClusterStateUpdateTask)new UpdateLifecyclePolicyTask(request, listener, this.licenseState, filteredHeaders, this.xContentRegistry, this.client));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static boolean isNoopUpdate(@Nullable LifecyclePolicyMetadata existingPolicy, LifecyclePolicy newPolicy, Map<String, String> filteredHeaders) {
        if (existingPolicy == null) {
            return false;
        }
        return newPolicy.equals((Object)existingPolicy.getPolicy()) && filteredHeaders.equals(existingPolicy.getHeaders());
    }

    private static void validatePrerequisites(LifecyclePolicy policy, ClusterState state, XPackLicenseState licenseState) {
        List<Phase> phasesWithSearchableSnapshotActions = policy.getPhases().values().stream().filter(phase -> phase.getActions().containsKey("searchable_snapshot")).toList();
        if (!phasesWithSearchableSnapshotActions.isEmpty() && !SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.checkWithoutTracking(licenseState)) {
            throw new IllegalArgumentException("policy [" + policy.getName() + "] defines the [searchable_snapshot] action but the current license is non-compliant for [searchable-snapshots]");
        }
        for (Phase phase2 : phasesWithSearchableSnapshotActions) {
            SearchableSnapshotAction action = (SearchableSnapshotAction)phase2.getActions().get("searchable_snapshot");
            String repository = action.getSnapshotRepository();
            if (RepositoriesMetadata.get((ClusterState)state).repository(repository) != null) continue;
            throw new IllegalArgumentException("no such repository [" + repository + "], the snapshot repository referenced by the [searchable_snapshot] action in the [" + phase2.getName() + "] phase must exist before it can be referenced by an ILM policy");
        }
        List<Phase> phasesWithWaitForSnapshotActions = policy.getPhases().values().stream().filter(phase -> phase.getActions().containsKey("wait_for_snapshot")).toList();
        for (Phase phase3 : phasesWithWaitForSnapshotActions) {
            WaitForSnapshotAction action = (WaitForSnapshotAction)phase3.getActions().get("wait_for_snapshot");
            String slmPolicy = action.getPolicy();
            if (((SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle", (Metadata.Custom)SnapshotLifecycleMetadata.EMPTY)).getSnapshotConfigurations().get(slmPolicy) != null) continue;
            throw new IllegalArgumentException("no such snapshot lifecycle policy [" + slmPolicy + "], the snapshot lifecycle policy referenced by the [wait_for_snapshot] action in the [" + phase3.getName() + "] phase must exist before it can be referenced by an ILM policy");
        }
    }

    protected ClusterBlockException checkBlock(PutLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("ilm");
    }

    public Set<String> modifiedKeys(PutLifecycleAction.Request request) {
        return Set.of(request.getPolicy().getName());
    }

    public static class UpdateLifecyclePolicyTask
    extends AckedClusterStateUpdateTask {
        private final PutLifecycleAction.Request request;
        private final XPackLicenseState licenseState;
        private final Map<String, String> filteredHeaders;
        private final NamedXContentRegistry xContentRegistry;
        private final Client client;
        private final boolean verboseLogging;

        public UpdateLifecyclePolicyTask(PutLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener, XPackLicenseState licenseState, Map<String, String> filteredHeaders, NamedXContentRegistry xContentRegistry, Client client) {
            super((AckedRequest)request, listener);
            this.request = request;
            this.licenseState = licenseState;
            this.filteredHeaders = filteredHeaders;
            this.xContentRegistry = xContentRegistry;
            this.client = client;
            this.verboseLogging = true;
        }

        UpdateLifecyclePolicyTask(PutLifecycleAction.Request request, XPackLicenseState licenseState, NamedXContentRegistry xContentRegistry, Client client) {
            super((AckedRequest)request, null);
            this.request = request;
            this.licenseState = licenseState;
            this.filteredHeaders = Collections.emptyMap();
            this.xContentRegistry = xContentRegistry;
            this.client = client;
            this.verboseLogging = false;
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle", (Metadata.Custom)IndexLifecycleMetadata.EMPTY);
            LifecyclePolicyMetadata existingPolicyMetadata = (LifecyclePolicyMetadata)currentMetadata.getPolicyMetadatas().get(this.request.getPolicy().getName());
            if (TransportPutLifecycleAction.isNoopUpdate(existingPolicyMetadata, this.request.getPolicy(), this.filteredHeaders)) {
                return currentState;
            }
            TransportPutLifecycleAction.validatePrerequisites(this.request.getPolicy(), currentState, this.licenseState);
            ClusterState.Builder stateBuilder = ClusterState.builder((ClusterState)currentState);
            long nextVersion = existingPolicyMetadata == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
            TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentMetadata.getPolicyMetadatas());
            LifecyclePolicyMetadata lifecyclePolicyMetadata = new LifecyclePolicyMetadata(this.request.getPolicy(), this.filteredHeaders, nextVersion, Instant.now().toEpochMilli());
            LifecyclePolicyMetadata oldPolicy = newPolicies.put(lifecyclePolicyMetadata.getName(), lifecyclePolicyMetadata);
            if (this.verboseLogging) {
                if (oldPolicy == null) {
                    logger.info("adding index lifecycle policy [{}]", (Object)this.request.getPolicy().getName());
                } else {
                    logger.info("updating index lifecycle policy [{}]", (Object)this.request.getPolicy().getName());
                }
            }
            IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, LifecycleOperationMetadata.currentILMMode((ClusterState)currentState));
            stateBuilder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("index_lifecycle", (Metadata.Custom)newMetadata).build());
            ClusterState nonRefreshedState = stateBuilder.build();
            if (oldPolicy == null) {
                return nonRefreshedState;
            }
            try {
                return PhaseCacheManagement.updateIndicesForPolicy((ClusterState)nonRefreshedState, (NamedXContentRegistry)this.xContentRegistry, (Client)this.client, (LifecyclePolicy)oldPolicy.getPolicy(), (LifecyclePolicyMetadata)lifecyclePolicyMetadata, (XPackLicenseState)this.licenseState);
            }
            catch (Exception e) {
                logger.warn(() -> "unable to refresh indices phase JSON for updated policy [" + oldPolicy.getName() + "]", (Throwable)e);
                return nonRefreshedState;
            }
        }
    }
}

