/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.CreateDataStreamAction;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.datastreams.MigrateToDataStreamAction;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.datastreams.PromoteDataStreamAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.DataStreamIndexSettingsProvider;
import org.elasticsearch.datastreams.UpdateTimeSeriesRangeService;
import org.elasticsearch.datastreams.action.CreateDataStreamTransportAction;
import org.elasticsearch.datastreams.action.DataStreamsStatsTransportAction;
import org.elasticsearch.datastreams.action.DeleteDataStreamTransportAction;
import org.elasticsearch.datastreams.action.GetDataStreamsTransportAction;
import org.elasticsearch.datastreams.action.MigrateToDataStreamTransportAction;
import org.elasticsearch.datastreams.action.ModifyDataStreamsTransportAction;
import org.elasticsearch.datastreams.action.PromoteDataStreamTransportAction;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleErrorStore;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleService;
import org.elasticsearch.datastreams.lifecycle.action.DeleteDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.ExplainDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.GetDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.GetDataStreamLifecycleStatsAction;
import org.elasticsearch.datastreams.lifecycle.action.PutDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.TransportDeleteDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.TransportExplainDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.TransportGetDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.action.TransportGetDataStreamLifecycleStatsAction;
import org.elasticsearch.datastreams.lifecycle.action.TransportPutDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.health.DataStreamLifecycleHealthInfoPublisher;
import org.elasticsearch.datastreams.lifecycle.rest.RestDataStreamLifecycleStatsAction;
import org.elasticsearch.datastreams.lifecycle.rest.RestDeleteDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.rest.RestExplainDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.rest.RestGetDataStreamLifecycleAction;
import org.elasticsearch.datastreams.lifecycle.rest.RestPutDataStreamLifecycleAction;
import org.elasticsearch.datastreams.rest.RestCreateDataStreamAction;
import org.elasticsearch.datastreams.rest.RestDataStreamsStatsAction;
import org.elasticsearch.datastreams.rest.RestDeleteDataStreamAction;
import org.elasticsearch.datastreams.rest.RestGetDataStreamsAction;
import org.elasticsearch.datastreams.rest.RestMigrateToDataStreamAction;
import org.elasticsearch.datastreams.rest.RestModifyDataStreamsAction;
import org.elasticsearch.datastreams.rest.RestPromoteDataStreamAction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;

public class DataStreamsPlugin
extends Plugin
implements ActionPlugin {
    public static final Setting<TimeValue> TIME_SERIES_POLL_INTERVAL = Setting.timeSetting((String)"time_series.poll_interval", (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueMinutes((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> LOOK_AHEAD_TIME = Setting.timeSetting((String)"index.look_ahead_time", (TimeValue)TimeValue.timeValueHours((long)2L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueDays((long)7L), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.ServerlessPublic});
    public static final String LIFECYCLE_CUSTOM_INDEX_METADATA_KEY = "data_stream_lifecycle";
    public static final Setting<TimeValue> LOOK_BACK_TIME = Setting.timeSetting((String)"index.look_back_time", (TimeValue)TimeValue.timeValueHours((long)2L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueDays((long)7L), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.ServerlessPublic});
    private final SetOnce<UpdateTimeSeriesRangeService> updateTimeSeriesRangeService = new SetOnce();
    private final SetOnce<DataStreamLifecycleErrorStore> errorStoreInitialisationService = new SetOnce();
    private final SetOnce<DataStreamLifecycleService> dataLifecycleInitialisationService = new SetOnce();
    private final SetOnce<DataStreamLifecycleHealthInfoPublisher> dataStreamLifecycleErrorsPublisher = new SetOnce();
    private final Settings settings;

    public DataStreamsPlugin(Settings settings) {
        this.settings = settings;
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    static void additionalLookAheadTimeValidation(TimeValue lookAhead, TimeValue timeSeriesPollInterval) {
        if (lookAhead.compareTo(timeSeriesPollInterval) < 0) {
            String message = String.format(Locale.ROOT, "failed to parse value%s for setting [%s], must be lower than setting [%s] which is [%s]", " [" + lookAhead.getStringRep() + "]", LOOK_AHEAD_TIME.getKey(), TIME_SERIES_POLL_INTERVAL.getKey(), timeSeriesPollInterval.getStringRep());
            throw new IllegalArgumentException(message);
        }
    }

    public List<Setting<?>> getSettings() {
        ArrayList pluginSettings = new ArrayList();
        pluginSettings.add(TIME_SERIES_POLL_INTERVAL);
        pluginSettings.add(LOOK_AHEAD_TIME);
        pluginSettings.add(LOOK_BACK_TIME);
        pluginSettings.add(DataStreamLifecycleService.DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING);
        pluginSettings.add(DataStreamLifecycleService.DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING);
        pluginSettings.add(DataStreamLifecycleService.DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING);
        pluginSettings.add(DataStreamLifecycleService.DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING);
        return pluginSettings;
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ArrayList<Object> components = new ArrayList<Object>();
        UpdateTimeSeriesRangeService updateTimeSeriesRangeService = new UpdateTimeSeriesRangeService(services.environment().settings(), services.threadPool(), services.clusterService());
        this.updateTimeSeriesRangeService.set((Object)updateTimeSeriesRangeService);
        components.add(this.updateTimeSeriesRangeService.get());
        this.errorStoreInitialisationService.set((Object)new DataStreamLifecycleErrorStore(() -> ((ThreadPool)services.threadPool()).absoluteTimeInMillis()));
        this.dataStreamLifecycleErrorsPublisher.set((Object)new DataStreamLifecycleHealthInfoPublisher(this.settings, services.client(), services.clusterService(), (DataStreamLifecycleErrorStore)this.errorStoreInitialisationService.get(), services.featureService()));
        this.dataLifecycleInitialisationService.set((Object)new DataStreamLifecycleService(this.settings, (Client)new OriginSettingClient(services.client(), LIFECYCLE_CUSTOM_INDEX_METADATA_KEY), services.clusterService(), this.getClock(), services.threadPool(), () -> ((ThreadPool)services.threadPool()).absoluteTimeInMillis(), (DataStreamLifecycleErrorStore)this.errorStoreInitialisationService.get(), services.allocationService(), (DataStreamLifecycleHealthInfoPublisher)this.dataStreamLifecycleErrorsPublisher.get()));
        ((DataStreamLifecycleService)this.dataLifecycleInitialisationService.get()).init();
        components.add(this.errorStoreInitialisationService.get());
        components.add(this.dataLifecycleInitialisationService.get());
        components.add(this.dataStreamLifecycleErrorsPublisher.get());
        return components;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)CreateDataStreamAction.INSTANCE, CreateDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)DeleteDataStreamAction.INSTANCE, DeleteDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetDataStreamAction.INSTANCE, GetDataStreamsTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)DataStreamsStatsAction.INSTANCE, DataStreamsStatsTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)MigrateToDataStreamAction.INSTANCE, MigrateToDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PromoteDataStreamAction.INSTANCE, PromoteDataStreamTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)ModifyDataStreamsAction.INSTANCE, ModifyDataStreamsTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(PutDataStreamLifecycleAction.INSTANCE, TransportPutDataStreamLifecycleAction.class));
        actions.add(new ActionPlugin.ActionHandler(GetDataStreamLifecycleAction.INSTANCE, TransportGetDataStreamLifecycleAction.class));
        actions.add(new ActionPlugin.ActionHandler(DeleteDataStreamLifecycleAction.INSTANCE, TransportDeleteDataStreamLifecycleAction.class));
        actions.add(new ActionPlugin.ActionHandler(ExplainDataStreamLifecycleAction.INSTANCE, TransportExplainDataStreamLifecycleAction.class));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetDataStreamLifecycleStatsAction.INSTANCE, TransportGetDataStreamLifecycleStatsAction.class));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        indexScopedSettings.addSettingsUpdateConsumer(LOOK_AHEAD_TIME, value -> {
            TimeValue timeSeriesPollInterval = ((UpdateTimeSeriesRangeService)((Object)((Object)this.updateTimeSeriesRangeService.get()))).pollInterval;
            DataStreamsPlugin.additionalLookAheadTimeValidation(value, timeSeriesPollInterval);
        });
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestCreateDataStreamAction());
        handlers.add((RestHandler)new RestDeleteDataStreamAction());
        handlers.add((RestHandler)new RestGetDataStreamsAction());
        handlers.add((RestHandler)new RestDataStreamsStatsAction());
        handlers.add((RestHandler)new RestMigrateToDataStreamAction());
        handlers.add((RestHandler)new RestPromoteDataStreamAction());
        handlers.add((RestHandler)new RestModifyDataStreamsAction());
        handlers.add((RestHandler)new RestPutDataStreamLifecycleAction());
        handlers.add((RestHandler)new RestGetDataStreamLifecycleAction());
        handlers.add((RestHandler)new RestDeleteDataStreamLifecycleAction());
        handlers.add((RestHandler)new RestExplainDataStreamLifecycleAction());
        handlers.add((RestHandler)new RestDataStreamLifecycleStatsAction());
        return handlers;
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        return List.of(new DataStreamIndexSettingsProvider((CheckedFunction<IndexMetadata, MapperService, IOException>)parameters.mapperServiceFactory()));
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable)((Closeable)this.dataLifecycleInitialisationService.get()));
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to close the data stream lifecycle service", (Throwable)e, new Object[0]);
        }
    }
}

