/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.Timestamp;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyToSequences;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceGroup;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.StageToKeys;
import org.elasticsearch.xpack.eql.execution.sequence.UntilGroup;

public class SequenceMatcher {
    private static final String CB_INFLIGHT_LABEL = "sequence_inflight";
    private static final String CB_COMPLETED_LABEL = "sequence_completed";
    private static final Logger log = LogManager.getLogger(SequenceMatcher.class);
    private final KeyToSequences keyToSequences;
    private final StageToKeys stageToKeys;
    private final int numberOfStages;
    private final int completionStage;
    private final Set<Sequence> completed;
    private final Set<Sequence> toCheckForMissing;
    private final long maxSpanInNanos;
    private final boolean descending;
    private final Limit limit;
    private final boolean[] missingEventStages;
    protected final int firstPositiveStage;
    protected final int lastPositiveStage;
    private final boolean missingEventStagesExist;
    private final CircuitBreaker circuitBreaker;
    private final Stats stats = new Stats();
    private boolean headLimit = false;
    private long prevRamBytesUsedInFlight = 0L;
    private long prevRamBytesUsedCompleted = 0L;

    public SequenceMatcher(int stages, boolean descending, TimeValue maxSpan, Limit limit, boolean[] missingEventStages, CircuitBreaker circuitBreaker) {
        this.numberOfStages = stages;
        this.completionStage = stages - 1;
        this.descending = descending;
        this.stageToKeys = new StageToKeys(this.completionStage);
        this.keyToSequences = new KeyToSequences(this.completionStage);
        this.completed = new TreeSet<Sequence>();
        this.toCheckForMissing = new TreeSet<Sequence>();
        this.maxSpanInNanos = maxSpan.nanos();
        this.limit = limit;
        this.missingEventStages = missingEventStages;
        this.firstPositiveStage = this.calculateFirstPositiveStage();
        this.lastPositiveStage = this.calculateLastPositiveStage();
        this.missingEventStagesExist = this.calculateMissingEventStagesExist();
        this.circuitBreaker = circuitBreaker;
    }

    private int calculateFirstPositiveStage() {
        for (int i = 0; i < this.missingEventStages.length; ++i) {
            if (this.missingEventStages[i]) continue;
            return i;
        }
        return -1;
    }

    private int calculateLastPositiveStage() {
        for (int i = this.missingEventStages.length - 1; i >= 0; --i) {
            if (this.missingEventStages[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean calculateMissingEventStagesExist() {
        for (int i = 0; i < this.missingEventStages.length; ++i) {
            if (!this.missingEventStages[i]) continue;
            return true;
        }
        return false;
    }

    private void trackSequence(Sequence sequence) {
        SequenceKey key = sequence.key();
        this.stageToKeys.add(this.firstPositiveStage, key);
        this.keyToSequences.add(this.firstPositiveStage, sequence);
        ++this.stats.seen;
    }

    boolean match(int stage, Iterable<Tuple<KeyAndOrdinal, HitReference>> hits) {
        boolean matched;
        for (Tuple<KeyAndOrdinal, HitReference> tuple : hits) {
            KeyAndOrdinal ko = (KeyAndOrdinal)tuple.v1();
            HitReference hit = (HitReference)tuple.v2();
            if (this.isFirstPositiveStage(stage)) {
                log.trace("Matching hit {}  - track sequence", (Object)ko.ordinal);
                Sequence seq = new Sequence(ko.key, this.numberOfStages, stage, ko.ordinal, hit);
                if (this.lastPositiveStage == stage) {
                    this.tryComplete(seq);
                    continue;
                }
                this.trackSequence(seq);
                continue;
            }
            log.trace("Matching hit {}  - match", (Object)ko.ordinal);
            this.match(stage, ko.key, ko.ordinal, hit);
            if (!this.headLimit) continue;
            log.trace("(Head) Limit reached {}", (Object)this.stats);
            return false;
        }
        if (this.tailLimitReached()) {
            log.trace("(Tail) Limit reached {}", (Object)this.stats);
            matched = false;
        } else {
            log.trace("{}", (Object)this.stats);
            matched = true;
        }
        this.trackMemory();
        return matched;
    }

    protected boolean exceedsMaxSpan(Timestamp from, Timestamp to) {
        return this.maxSpanInNanos > 0L && to.delta(from) > this.maxSpanInNanos;
    }

    private boolean tailLimitReached() {
        return this.limit != null && this.limit.limit() < 0 && this.limit.absLimit() <= this.completed.size();
    }

    private void match(int stage, SequenceKey key, Ordinal ordinal, HitReference hit) {
        Ordinal nearestUntil;
        ++this.stats.seen;
        int previousStage = this.previousPositiveStage(stage);
        SequenceGroup group = this.keyToSequences.groupIfPresent(previousStage, key);
        if (group == null || group.isEmpty()) {
            ++this.stats.ignored;
            return;
        }
        Sequence sequence = (Sequence)group.trimBefore(ordinal);
        if (sequence == null) {
            ++this.stats.ignored;
            return;
        }
        if (group.isEmpty()) {
            this.keyToSequences.remove(previousStage, key);
            this.stageToKeys.remove(previousStage, key);
        }
        if (this.exceedsMaxSpan(sequence.startOrdinal().timestamp(), ordinal.timestamp())) {
            ++this.stats.rejectionMaxspan;
            return;
        }
        UntilGroup until = this.keyToSequences.untilIfPresent(key);
        if (until != null && (nearestUntil = (Ordinal)until.before(ordinal)) != null && nearestUntil.between(sequence.ordinal(), ordinal)) {
            ++this.stats.rejectionUntil;
            return;
        }
        sequence.putMatch(stage, ordinal, hit);
        if (stage == this.lastPositiveStage) {
            if (this.descending) {
                for (Sequence seen : this.completed) {
                    if (!seen.key().equals(key) || !seen.ordinal().equals(ordinal)) continue;
                    return;
                }
            }
            this.tryComplete(sequence);
            this.calculateHeadLimit();
        } else {
            this.stageToKeys.add(stage, key);
            this.keyToSequences.add(stage, sequence);
        }
    }

    public void tryComplete(Sequence sequence) {
        if (this.missingEventStagesExist) {
            this.toCheckForMissing.add(sequence);
        } else {
            this.completed.add(sequence);
        }
    }

    private void calculateHeadLimit() {
        this.headLimit = this.limit != null && this.limit.limit() > 0 && this.completed.size() == this.limit.totalLimit();
    }

    int previousPositiveStage(int stage) {
        for (int i = stage - 1; i >= 0; --i) {
            if (this.missingEventStages[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean limitReached() {
        this.calculateHeadLimit();
        return this.headLimit;
    }

    int nextPositiveStage(int stage) {
        for (int i = stage + 1; i < this.missingEventStages.length; ++i) {
            if (this.missingEventStages[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isMissingEvent(int stage) {
        if (stage < 0 || stage >= this.missingEventStages.length) {
            return false;
        }
        return this.missingEventStages[stage];
    }

    private boolean isFirstPositiveStage(int stage) {
        return stage == this.firstPositiveStage;
    }

    boolean hasFollowingCandidates(int stage) {
        return this.hasCandidates(stage, this.completionStage);
    }

    boolean hasCandidates() {
        return this.hasCandidates(0, this.completionStage);
    }

    private boolean hasCandidates(int start, int stop) {
        for (int i = start; i < stop; ++i) {
            if (this.stageToKeys.isEmpty(i)) continue;
            return true;
        }
        return false;
    }

    Set<SequenceKey> keys(int stage) {
        return this.stageToKeys.keys(stage);
    }

    Set<SequenceKey> keys() {
        return this.stageToKeys.keys();
    }

    List<Sequence> completed() {
        ArrayList<Sequence> asList = new ArrayList<Sequence>(this.completed);
        return this.limit != null ? this.limit.view(asList) : asList;
    }

    void until(Iterable<KeyAndOrdinal> markers) {
        this.keyToSequences.until(markers);
    }

    void trim(Ordinal ordinal) {
        if (ordinal == null) {
            this.keyToSequences.clear();
        } else {
            this.keyToSequences.trimToTail(ordinal);
        }
    }

    public void addToCompleted(Sequence sequence) {
        this.completed.add(sequence);
    }

    Set<Sequence> toCheckForMissing() {
        return this.toCheckForMissing;
    }

    public void clear() {
        this.stats.clear();
        this.keyToSequences.clear();
        this.stageToKeys.clear();
        this.completed.clear();
        this.toCheckForMissing.clear();
        this.clearCircuitBreaker();
    }

    protected long ramBytesUsedInFlight() {
        return RamUsageEstimator.sizeOf((Accountable)this.keyToSequences) + RamUsageEstimator.sizeOf((Accountable)this.stageToKeys);
    }

    protected long ramBytesUsedCompleted() {
        return RamUsageEstimator.sizeOfCollection(this.completed);
    }

    private void clearCircuitBreaker() {
        this.circuitBreaker.addWithoutBreaking(-this.prevRamBytesUsedInFlight - this.prevRamBytesUsedCompleted);
        this.prevRamBytesUsedInFlight = 0L;
        this.prevRamBytesUsedCompleted = 0L;
    }

    private void trackMemory() {
        long newRamBytesUsedInFlight = this.ramBytesUsedInFlight();
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(newRamBytesUsedInFlight - this.prevRamBytesUsedInFlight, CB_INFLIGHT_LABEL);
        this.prevRamBytesUsedInFlight = newRamBytesUsedInFlight;
        long newRamBytesUsedCompleted = this.ramBytesUsedCompleted();
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(newRamBytesUsedCompleted - this.prevRamBytesUsedCompleted, CB_COMPLETED_LABEL);
        this.prevRamBytesUsedCompleted = newRamBytesUsedCompleted;
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"Tracking [{}] keys with [{}] completed and {} in-flight", (Object[])new Object[]{this.keyToSequences, this.completed.size(), this.stageToKeys});
    }

    static class Stats {
        long seen = 0L;
        long ignored = 0L;
        long rejectionMaxspan = 0L;
        long rejectionUntil = 0L;

        Stats() {
        }

        public String toString() {
            return LoggerMessageFormat.format(null, (String)"Stats: Seen [{}]/Ignored [{}]/Rejected {Maxspan [{}]/Until [{}]}", (Object[])new Object[]{this.seen, this.ignored, this.rejectionMaxspan, this.rejectionUntil});
        }

        public void clear() {
            this.seen = 0L;
            this.ignored = 0L;
            this.rejectionMaxspan = 0L;
            this.rejectionUntil = 0L;
        }
    }
}

