/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.core.Strings;

public class DocumentConversionUtils {
    private static final Logger logger = LogManager.getLogger(DocumentConversionUtils.class);

    public static IndexRequest convertDocumentToIndexRequest(String docId, Map<String, Object> document, String destinationIndex, String destinationPipeline) {
        if (docId == null) {
            throw new RuntimeException("Expected a document id but got null.");
        }
        return new IndexRequest(destinationIndex).id(docId).source(document).setPipeline(destinationPipeline);
    }

    public static <V> Map<String, V> removeInternalFields(Map<String, V> document) {
        return document.entrySet().stream().filter(Predicate.not(e -> e.getKey() != null && ((String)e.getKey()).startsWith("_"))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    public static Map<String, String> extractFieldMappings(FieldCapabilitiesResponse response) {
        HashMap<String, String> extractedTypes = new HashMap<String, String>();
        response.get().forEach((fieldName, capabilitiesMap) -> capabilitiesMap.forEach((name, capability) -> {
            logger.trace(() -> Strings.format((String)"Extracted type for [%s] : [%s]", (Object[])new Object[]{fieldName, capability.getType()}));
            extractedTypes.put((String)fieldName, capability.getType());
        }));
        return extractedTypes;
    }

    private DocumentConversionUtils() {
    }
}

