/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointAction;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointNodeAction;
import org.elasticsearch.xpack.transform.action.TransportGetCheckpointNodeAction;

public class TransportGetCheckpointAction
extends HandledTransportAction<GetCheckpointAction.Request, GetCheckpointAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetCheckpointAction.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final TransportService transportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;

    @Inject
    public TransportGetCheckpointAction(TransportService transportService, ActionFilters actionFilters, IndicesService indicesService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("indices:monitor/transform/checkpoint", transportService, actionFilters, GetCheckpointAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
    }

    protected void doExecute(Task task, GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        this.resolveIndicesAndGetCheckpoint(task, request, listener, clusterState);
    }

    protected void resolveIndicesAndGetCheckpoint(Task task, GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener, ClusterState clusterState) {
        String nodeId = clusterState.nodes().getLocalNode().getId();
        TaskId parentTaskId = new TaskId(nodeId, task.getId());
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
        Map<String, Set<ShardId>> nodesAndShards = TransportGetCheckpointAction.resolveIndicesToPrimaryShards(clusterState, concreteIndices);
        if (nodesAndShards.isEmpty()) {
            listener.onResponse((Object)new GetCheckpointAction.Response(Collections.emptyMap()));
            return;
        }
        if (request.getQuery() == null) {
            this.getCheckpointsFromNodes(clusterState, task, nodesAndShards, new OriginalIndices((IndicesRequest)request), request.getTimeout(), listener);
            return;
        }
        SearchShardsRequest searchShardsRequest = new SearchShardsRequest(request.indices(), SearchRequest.DEFAULT_INDICES_OPTIONS, request.getQuery(), null, null, false, request.getCluster());
        searchShardsRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)TransportSearchShardsAction.TYPE, (ActionRequest)searchShardsRequest, (ActionListener)ActionListener.wrap(searchShardsResponse -> {
            Map<String, Set<ShardId>> filteredNodesAndShards = TransportGetCheckpointAction.filterOutSkippedShards(nodesAndShards, searchShardsResponse);
            this.getCheckpointsFromNodes(clusterState, task, filteredNodesAndShards, new OriginalIndices((IndicesRequest)request), request.getTimeout(), listener);
        }, e -> {
            logger.atWarn().withThrowable((Throwable)e).log("search_shards API failed for cluster [{}]", (Object)request.getCluster());
            logger.atTrace().withThrowable((Throwable)e).log("search_shards API failed for cluster [{}], request was [{}]", (Object)request.getCluster(), (Object)searchShardsRequest);
            this.getCheckpointsFromNodes(clusterState, task, nodesAndShards, new OriginalIndices((IndicesRequest)request), request.getTimeout(), listener);
        }));
    }

    private static Map<String, Set<ShardId>> resolveIndicesToPrimaryShards(ClusterState clusterState, String[] concreteIndices) {
        if (concreteIndices.length == 0) {
            return Collections.emptyMap();
        }
        DiscoveryNodes nodes = clusterState.nodes();
        HashMap<String, Set<ShardId>> nodesAndShards = new HashMap<String, Set<ShardId>>();
        ShardsIterator shardsIt = clusterState.routingTable().allShards(concreteIndices);
        for (ShardRouting shard : shardsIt) {
            if (!shard.primary()) continue;
            if (shard.assignedToNode() && nodes.get(shard.currentNodeId()) != null) {
                if (clusterState.getMinTransportVersion().before((VersionId)TransportVersions.V_8_2_0)) {
                    throw new ActionNotFoundTransportException("indices:monitor/transform/checkpoint[n]");
                }
                String nodeId = shard.currentNodeId();
                nodesAndShards.computeIfAbsent(nodeId, k -> new HashSet()).add(shard.shardId());
                continue;
            }
            throw new NoShardAvailableActionException(shard.shardId(), " no primary shards available for shard [" + shard + "]");
        }
        return nodesAndShards;
    }

    static Map<String, Set<ShardId>> filterOutSkippedShards(Map<String, Set<ShardId>> nodesAndShards, SearchShardsResponse searchShardsResponse) {
        HashMap<String, Set<ShardId>> filteredNodesAndShards = new HashMap<String, Set<ShardId>>(nodesAndShards.size());
        for (Map.Entry<String, Set<ShardId>> nodeAndShardsEntry : nodesAndShards.entrySet()) {
            String node = nodeAndShardsEntry.getKey();
            Set<ShardId> shards = nodeAndShardsEntry.getValue();
            filteredNodesAndShards.put(node, new HashSet<ShardId>(shards));
        }
        for (SearchShardsGroup shardGroup : searchShardsResponse.getGroups()) {
            if (!shardGroup.skipped()) continue;
            for (String allocatedNode : shardGroup.allocatedNodes()) {
                Set shards = (Set)filteredNodesAndShards.get(allocatedNode);
                if (shards == null) continue;
                shards.remove(shardGroup.shardId());
                if (!shards.isEmpty()) continue;
                filteredNodesAndShards.remove(allocatedNode);
            }
        }
        return filteredNodesAndShards;
    }

    private void getCheckpointsFromNodes(ClusterState clusterState, Task task, Map<String, Set<ShardId>> nodesAndShards, OriginalIndices originalIndices, TimeValue timeout, ActionListener<GetCheckpointAction.Response> listener) {
        if (nodesAndShards.isEmpty()) {
            listener.onResponse((Object)new GetCheckpointAction.Response(Map.of()));
            return;
        }
        String localNodeId = this.clusterService.localNode().getId();
        GroupedActionListener groupedListener = new GroupedActionListener(nodesAndShards.size(), ActionListener.wrap(responses -> listener.onResponse((Object)TransportGetCheckpointAction.mergeNodeResponses(responses)), arg_0 -> listener.onFailure(arg_0)));
        for (Map.Entry<String, Set<ShardId>> oneNodeAndItsShards : nodesAndShards.entrySet()) {
            if (task instanceof CancellableTask && ((CancellableTask)task).notifyIfCancelled(listener)) {
                return;
            }
            if (localNodeId.equals(oneNodeAndItsShards.getKey())) {
                TransportGetCheckpointNodeAction.getGlobalCheckpoints(this.indicesService, task, oneNodeAndItsShards.getValue(), timeout, Clock.systemUTC(), (ActionListener<GetCheckpointNodeAction.Response>)groupedListener);
                continue;
            }
            DiscoveryNodes nodes = clusterState.nodes();
            DiscoveryNode node = nodes.get(oneNodeAndItsShards.getKey());
            if (node == null) {
                listener.onFailure((Exception)new UnavailableShardsException(oneNodeAndItsShards.getValue().iterator().next(), "Node not found for [{}] shards", new Object[]{oneNodeAndItsShards.getValue().size()}));
                return;
            }
            logger.trace("get checkpoints from node {}", (Object)node);
            GetCheckpointNodeAction.Request nodeCheckpointsRequest = new GetCheckpointNodeAction.Request(oneNodeAndItsShards.getValue(), originalIndices, timeout);
            this.transportService.sendChildRequest(node, "indices:monitor/transform/checkpoint[n]", (TransportRequest)nodeCheckpointsRequest, task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)groupedListener, GetCheckpointNodeAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    private static GetCheckpointAction.Response mergeNodeResponses(Collection<GetCheckpointNodeAction.Response> responses) {
        TreeMap checkpointsByIndexReduced = new TreeMap();
        for (GetCheckpointNodeAction.Response response : responses) {
            response.getCheckpoints().forEach((index, checkpoint) -> {
                if (checkpointsByIndexReduced.containsKey(index)) {
                    long[] shardCheckpoints = (long[])checkpointsByIndexReduced.get(index);
                    for (int i = 0; i < ((long[])checkpoint).length; ++i) {
                        shardCheckpoints[i] = Math.max(shardCheckpoints[i], checkpoint[i]);
                    }
                } else {
                    checkpointsByIndexReduced.put(index, checkpoint);
                }
            });
        }
        return new GetCheckpointAction.Response(checkpointsByIndexReduced);
    }
}

