/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.template.resources.TemplateResources;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static void loadLegacyTemplateIntoMap(String resource, Map<String, IndexTemplateMetadata> map, String templateName, String version, String versionProperty, Logger logger) {
        String template = TemplateUtils.loadTemplate(resource, version, versionProperty);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, template);){
            map.put(templateName, IndexTemplateMetadata.Builder.fromXContent((XContentParser)parser, (String)templateName));
        }
        catch (IOException e) {
            logger.error("Error loading template [{}] as part of metadata upgrading", (Object)templateName);
        }
    }

    public static String loadTemplate(String resource, String version, String versionProperty) {
        return TemplateUtils.loadTemplate(resource, version, versionProperty, Collections.emptyMap());
    }

    public static String loadTemplate(String resource, String version, String versionProperty, Map<String, String> variables) {
        try {
            String source = TemplateResources.load((String)resource);
            source = TemplateUtils.replaceVariables(source, version, versionProperty, variables);
            TemplateUtils.validate(source);
            return source;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load template [" + resource + "]", e);
        }
    }

    public static void validate(String source) {
        if (source == null) {
            throw new ElasticsearchParseException("Template must not be null", new Object[0]);
        }
        if (Strings.isEmpty((CharSequence)source)) {
            throw new ElasticsearchParseException("Template must not be empty", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)source, (boolean)false);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid template", (Throwable)e, new Object[0]);
        }
    }

    public static String replaceVariables(String input, String version, String versionProperty, Map<String, String> variables) {
        String template = TemplateUtils.replaceVariable(input, versionProperty, version);
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            template = TemplateUtils.replaceVariable(template, variable.getKey(), variable.getValue());
        }
        return template;
    }

    public static String replaceVariable(String input, String variable, String value) {
        return Pattern.compile("${" + variable + "}", 16).matcher(input).replaceAll(value);
    }

    public static boolean checkTemplateExistsAndVersionIsGTECurrentVersion(String templateName, ClusterState state, long currentVersion) {
        ComposableIndexTemplate templateMetadata = (ComposableIndexTemplate)state.metadata().templatesV2().get(templateName);
        if (templateMetadata == null) {
            return false;
        }
        return templateMetadata.version() != null && templateMetadata.version() >= currentVersion;
    }

    public static boolean checkTemplateExistsAndIsUpToDate(String templateName, String versionKey, ClusterState state, Logger logger) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches(templateName, versionKey, state, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, String versionKey, ClusterState state, Logger logger, Predicate<Version> predicate) {
        IndexTemplateMetadata templateMeta = (IndexTemplateMetadata)state.metadata().templates().get(templateName);
        if (templateMeta == null) {
            return false;
        }
        CompressedXContent mappings = templateMeta.getMappings();
        if (mappings != null) {
            try {
                Map typeMappingMap = (Map)XContentHelper.convertToMap((BytesReference)mappings.uncompressed(), (boolean)false, (XContentType)XContentType.JSON).v2();
                assert (typeMappingMap.size() == 1);
                String key = (String)typeMappingMap.keySet().iterator().next();
                Map mappingMap = (Map)typeMappingMap.get(key);
                if (!TemplateUtils.containsCorrectVersion(versionKey, mappingMap, predicate)) {
                    return false;
                }
            }
            catch (ElasticsearchParseException e) {
                logger.error(() -> "Cannot parse the template [" + templateName + "]", (Throwable)e);
                throw new IllegalStateException("Cannot parse the template " + templateName, e);
            }
        }
        return true;
    }

    private static boolean containsCorrectVersion(String versionKey, Map<String, Object> typeMappingMap, Predicate<Version> predicate) {
        Map meta = (Map)typeMappingMap.get("_meta");
        if (meta == null) {
            return false;
        }
        return predicate.test(Version.fromString((String)((String)meta.get(versionKey))));
    }
}

