/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;

public final class DelegatePkiAuthenticationRequest
extends ActionRequest
implements ToXContentObject {
    private static final ParseField X509_CERTIFICATE_CHAIN_FIELD = new ParseField("x509_certificate_chain", new String[0]);
    public static final ConstructingObjectParser<DelegatePkiAuthenticationRequest, Void> PARSER = new ConstructingObjectParser("delegate_pki_request", false, a -> {
        List certificates = (List)a[0];
        return new DelegatePkiAuthenticationRequest(certificates);
    });
    private final List<X509Certificate> certificateChain;

    public static DelegatePkiAuthenticationRequest fromXContent(XContentParser parser) throws IOException {
        return (DelegatePkiAuthenticationRequest)((Object)PARSER.apply(parser, null));
    }

    public DelegatePkiAuthenticationRequest(List<X509Certificate> certificateChain) {
        this.certificateChain = List.copyOf(certificateChain);
    }

    public DelegatePkiAuthenticationRequest(StreamInput input) throws IOException {
        super(input);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            this.certificateChain = input.readCollectionAsImmutableList(in -> {
                X509Certificate x509Certificate;
                ByteArrayInputStream bis = new ByteArrayInputStream(in.readByteArray());
                try {
                    x509Certificate = (X509Certificate)certificateFactory.generateCertificate(bis);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (CertificateException e) {
                        throw new IOException(e);
                    }
                }
                bis.close();
                return x509Certificate;
            });
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.certificateChain.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"certificates chain must not be empty", validationException);
        } else if (!CertParsingUtils.isOrderedCertificateChain(this.certificateChain)) {
            validationException = ValidateActions.addValidationError((String)"certificates chain must be an ordered chain", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public void writeTo(StreamOutput output) throws IOException {
        super.writeTo(output);
        output.writeCollection(this.certificateChain, (out, cert) -> {
            try {
                out.writeByteArray(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DelegatePkiAuthenticationRequest that = (DelegatePkiAuthenticationRequest)((Object)o);
        return Objects.equals(this.certificateChain, that.certificateChain);
    }

    public int hashCode() {
        return Objects.hashCode(this.certificateChain);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startArray(X509_CERTIFICATE_CHAIN_FIELD.getPreferredName());
        try {
            for (X509Certificate cert : this.certificateChain) {
                builder.value(Base64.getEncoder().encodeToString(cert.getEncoded()));
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
        return builder.endArray().endObject();
    }

    static {
        PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (parser, c) -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(parser.text()));
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException(e);
                }
            }
            bis.close();
            return x509Certificate;
        }, X509_CERTIFICATE_CHAIN_FIELD, ObjectParser.ValueType.STRING_ARRAY);
    }
}

