/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ResultsFieldUpdate
implements InferenceConfigUpdate {
    public static final String NAME = "field_update";
    private final String resultsField;

    public ResultsFieldUpdate(String resultsField) {
        this.resultsField = Objects.requireNonNull(resultsField);
    }

    public ResultsFieldUpdate(StreamInput in) throws IOException {
        this.resultsField = in.readString();
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (originalConfig instanceof ClassificationConfig) {
            ClassificationConfigUpdate update = new ClassificationConfigUpdate(null, this.resultsField, null, null, null);
            return update.apply(originalConfig);
        }
        if (originalConfig instanceof RegressionConfig) {
            RegressionConfigUpdate update = new RegressionConfigUpdate(this.resultsField, null);
            return update.apply(originalConfig);
        }
        throw ExceptionsHelper.badRequestException("Inference config of unknown type [{}] can not be updated", originalConfig.getName());
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return true;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setResultsField(this.resultsField);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_9_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultsFieldUpdate that = (ResultsFieldUpdate)o;
        return Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hashCode(this.resultsField);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, ResultsFieldUpdate> {
        private String resultsField;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        @Override
        public ResultsFieldUpdate build() {
            return new ResultsFieldUpdate(this.resultsField);
        }
    }
}

