/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class PassThroughConfig
implements NlpConfig {
    public static final String NAME = "pass_through";
    private static final ConstructingObjectParser<PassThroughConfig, Void> STRICT_PARSER = PassThroughConfig.createParser(false);
    private static final ConstructingObjectParser<PassThroughConfig, Void> LENIENT_PARSER = PassThroughConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final String resultsField;

    public static PassThroughConfig fromXContentStrict(XContentParser parser) {
        return (PassThroughConfig)STRICT_PARSER.apply(parser, null);
    }

    public static PassThroughConfig fromXContentLenient(XContentParser parser) {
        return (PassThroughConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<PassThroughConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new PassThroughConfig((VocabularyConfig)a[0], (Tokenization)a[1], (String)a[2]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public PassThroughConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.resultsField = resultsField;
        if (this.tokenization.span != -1) {
            throw ExceptionsHelper.badRequestException("[{}] does not support windowing long text sequences; configured span [{}]", NAME, this.tokenization.span);
        }
    }

    public PassThroughConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.resultsField = in.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_0_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_0_0;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PassThroughConfig that = (PassThroughConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.resultsField);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }
}

