/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class CheckTargetShardsCountStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-target-shards-count";
    private final Integer numberOfShards;
    private static final Logger logger = LogManager.getLogger(CheckTargetShardsCountStep.class);

    CheckTargetShardsCountStep(Step.StepKey key, Step.StepKey nextStepKey, Integer numberOfShards) {
        super(key, nextStepKey);
        this.numberOfShards = numberOfShards;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        int sourceNumberOfShards;
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        String indexName = indexMetadata.getIndex().getName();
        if (this.numberOfShards != null && (sourceNumberOfShards = indexMetadata.getNumberOfShards()) % this.numberOfShards != 0) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            String errorMessage = String.format(Locale.ROOT, "lifecycle action of policy [%s] for index [%s] cannot make progress because the target shards count [%d] must be a factor of the source index's shards count [%d]", policyName, indexName, this.numberOfShards, sourceNumberOfShards);
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
        }
        return new ClusterStateWaitStep.Result(true, null);
    }
}

