/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseSettings;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.PostStartTrialRequest;
import org.elasticsearch.license.PostStartTrialResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.license.internal.TrialLicenseVersion;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartTrialClusterTask
implements ClusterStateTaskListener {
    private static final String ACKNOWLEDGEMENT_HEADER = "This API initiates a free 30-day trial for all platinum features. By starting this trial, you agree that it is subject to the terms and conditions at https://www.elastic.co/legal/trial_license/. To begin your free trial, call /start_trial again and specify the \"acknowledge=true\" parameter.";
    private static final Map<String, String[]> ACK_MESSAGES = Collections.singletonMap("security", new String[]{"With a trial license, X-Pack security features are available, but are not enabled by default."});
    static final String TASK_SOURCE = "started trial license";
    private final Logger logger;
    private final String clusterName;
    private final PostStartTrialRequest request;
    private final ActionListener<PostStartTrialResponse> listener;
    private final Clock clock;

    StartTrialClusterTask(Logger logger, String clusterName, Clock clock, PostStartTrialRequest request, ActionListener<PostStartTrialResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.listener = listener;
        this.clock = clock;
    }

    private LicensesMetadata execute(LicensesMetadata currentLicensesMetadata, DiscoveryNodes discoveryNodes, ClusterStateTaskExecutor.TaskContext<StartTrialClusterTask> taskContext) {
        assert (taskContext.getTask() == this);
        if (discoveryNodes.getMaxNodeVersion().after((VersionId)discoveryNodes.getSmallestNonClientNodeVersion())) {
            throw new IllegalStateException("Please ensure all nodes are on the same version before starting your trial, the highest node version in this cluster is [" + discoveryNodes.getMaxNodeVersion() + "] and the lowest node version is [" + discoveryNodes.getMinNodeVersion() + "]");
        }
        ActionListener listener = ActionListener.runBefore(this.listener, () -> this.logger.debug("started self generated trial license: {}", (Object)currentLicensesMetadata));
        if (!this.request.isAcknowledged()) {
            taskContext.success(() -> listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.NEED_ACKNOWLEDGEMENT, ACK_MESSAGES, ACKNOWLEDGEMENT_HEADER)));
            return currentLicensesMetadata;
        }
        if (currentLicensesMetadata == null || currentLicensesMetadata.isEligibleForTrial()) {
            long issueDate = this.clock.millis();
            long expiryDate = issueDate + LicenseSettings.NON_BASIC_SELF_GENERATED_LICENSE_DURATION.getMillis();
            License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).issueDate(issueDate).type(this.request.getType()).expiryDate(expiryDate);
            if (License.LicenseType.isEnterprise(this.request.getType())) {
                specBuilder.maxResourceUnits(1000);
            } else {
                specBuilder.maxNodes(1000);
            }
            License selfGeneratedLicense = SelfGeneratedLicense.create(specBuilder, discoveryNodes);
            LicensesMetadata newLicensesMetadata = new LicensesMetadata(selfGeneratedLicense, TrialLicenseVersion.CURRENT);
            taskContext.success(() -> listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.UPGRADED_TO_TRIAL)));
            return newLicensesMetadata;
        }
        taskContext.success(() -> listener.onResponse((Object)new PostStartTrialResponse(PostStartTrialResponse.Status.TRIAL_ALREADY_ACTIVATED)));
        return currentLicensesMetadata;
    }

    public void onFailure(@Nullable Exception e) {
        this.logger.error("unexpected failure during [started trial license]", (Throwable)e);
        this.listener.onFailure(e);
    }

    static class Executor
    implements ClusterStateTaskExecutor<StartTrialClusterTask> {
        Executor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<StartTrialClusterTask> batchExecutionContext) throws Exception {
            LicensesMetadata originalLicensesMetadata;
            ClusterState initialState = batchExecutionContext.initialState();
            XPackPlugin.checkReadyForXPackCustomMetadata(initialState);
            LicensesMetadata currentLicensesMetadata = originalLicensesMetadata = (LicensesMetadata)initialState.metadata().custom("licenses");
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                Releasable ignored = taskContext.captureResponseHeaders();
                try {
                    currentLicensesMetadata = ((StartTrialClusterTask)taskContext.getTask()).execute(currentLicensesMetadata, initialState.nodes(), (ClusterStateTaskExecutor.TaskContext<StartTrialClusterTask>)taskContext);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            if (currentLicensesMetadata == originalLicensesMetadata) {
                return initialState;
            }
            return ClusterState.builder((ClusterState)initialState).metadata(Metadata.builder((Metadata)initialState.metadata()).putCustom("licenses", (Metadata.Custom)currentLicensesMetadata)).build();
        }
    }
}

