/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCloseJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/_close")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/_close", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_close_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        CloseJobAction.Request request;
        if (restRequest.hasContentOrSourceParam()) {
            request = CloseJobAction.Request.parseRequest((String)restRequest.param(Job.ID.getPreferredName()), (XContentParser)restRequest.contentParser());
        } else {
            request = new CloseJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
            if (restRequest.hasParam(CloseJobAction.Request.TIMEOUT.getPreferredName())) {
                request.setCloseTimeout(TimeValue.parseTimeValue((String)restRequest.param(CloseJobAction.Request.TIMEOUT.getPreferredName()), (String)CloseJobAction.Request.TIMEOUT.getPreferredName()));
            }
            if (restRequest.hasParam(CloseJobAction.Request.FORCE.getPreferredName())) {
                request.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), request.isForce()));
            }
            RestCompatibilityChecker.checkAndSetDeprecatedParam("allow_no_jobs", CloseJobAction.Request.ALLOW_NO_MATCH.getPreferredName(), RestApiVersion.V_7, restRequest, (r, s) -> r.paramAsBoolean(s, request.allowNoMatch()), arg_0 -> ((CloseJobAction.Request)request).setAllowNoMatch(arg_0));
        }
        return channel -> client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

