/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.ml.action.MlMemoryAction;

@ServerlessScope(value=Scope.INTERNAL)
public class RestMlMemoryAction
extends BaseRestHandler {
    public static final String NODE_ID = "nodeId";
    public static final String MASTER_TIMEOUT = "master_timeout";
    public static final String TIMEOUT = "timeout";

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ml/memory/{nodeId}/_stats"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/memory/_stats"));
    }

    public String getName() {
        return "ml_memory_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String nodeId = restRequest.param(NODE_ID);
        if (Strings.isNullOrEmpty((String)nodeId)) {
            nodeId = "_all";
        }
        MlMemoryAction.Request request = new MlMemoryAction.Request(nodeId);
        request.masterNodeTimeout(restRequest.paramAsTime(MASTER_TIMEOUT, request.masterNodeTimeout()));
        request.timeout(restRequest.paramAsTime(TIMEOUT, request.timeout()));
        return channel -> client.execute((ActionType)MlMemoryAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

