/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.process;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcess;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcessFactory;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchStateStreamer;
import org.elasticsearch.xpack.ml.inference.pytorch.results.PyTorchResult;
import org.elasticsearch.xpack.ml.process.AbstractNativeProcess;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;

public class NativePyTorchProcess
extends AbstractNativeProcess
implements PyTorchProcess {
    private static final String NAME = "pytorch_inference";
    private final ProcessResultsParser<PyTorchResult> resultsParser;
    private final PyTorchProcessFactory.TimeoutRunnable afterInStreamClose;

    protected NativePyTorchProcess(String jobId, NativeController nativeController, ProcessPipes processPipes, int numberOfFields, List<Path> filesToDelete, PyTorchProcessFactory.TimeoutRunnable afterInStreamClose, Consumer<String> onProcessCrash) {
        super(jobId, nativeController, processPipes, numberOfFields, filesToDelete, onProcessCrash);
        this.afterInStreamClose = afterInStreamClose;
        this.resultsParser = new ProcessResultsParser<PyTorchResult>(PyTorchResult.PARSER, NamedXContentRegistry.EMPTY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void persistState() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void persistState(long snapshotTimestampMs, String snapshotId, String snapshotDescription) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadModel(String modelId, String index, PyTorchStateStreamer stateStreamer, ActionListener<Boolean> listener) {
        stateStreamer.writeStateToStream(modelId, index, this.processRestoreStream(), listener);
    }

    @Override
    public Iterator<PyTorchResult> readResults() {
        return this.resultsParser.parseResults(this.processOutStream());
    }

    @Override
    public void writeInferenceRequest(BytesReference jsonRequest) throws IOException {
        this.processInStream().write(jsonRequest.array(), jsonRequest.arrayOffset(), jsonRequest.length());
        this.processInStream().write(10);
        this.processInStream().flush();
    }

    @Override
    protected void afterProcessInStreamClose() throws TimeoutException {
        this.afterInStreamClose.run();
    }
}

