/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregatorFactory;

public class CategorizeTextAggregationBuilder
extends AbstractAggregationBuilder<CategorizeTextAggregationBuilder> {
    static final TermsAggregator.ConstantBucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.ConstantBucketCountThresholds(1L, 0L, 10, -1);
    public static final String NAME = "categorize_text";
    public static final TransportVersion ALGORITHM_CHANGED_VERSION = TransportVersions.V_8_3_0;
    static final ParseField FIELD_NAME = new ParseField("field", new String[0]);
    static final ParseField SIMILARITY_THRESHOLD = new ParseField("similarity_threshold", new String[0]);
    static final ParseField MAX_UNIQUE_TOKENS = new ParseField("max_unique_tokens", new String[0]).withAllDeprecated();
    static final ParseField MAX_MATCHED_TOKENS = new ParseField("max_matched_tokens", new String[0]).withAllDeprecated();
    static final ParseField CATEGORIZATION_FILTERS = new ParseField("categorization_filters", new String[0]);
    static final ParseField CATEGORIZATION_ANALYZER = new ParseField("categorization_analyzer", new String[0]);
    public static final ObjectParser<CategorizeTextAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"categorize_text", CategorizeTextAggregationBuilder::new);
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    private CategorizationAnalyzerConfig categorizationAnalyzerConfig;
    private String fieldName;
    private int similarityThreshold = 70;

    public static CategorizeTextAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (CategorizeTextAggregationBuilder)((Object)PARSER.parse(parser, (Object)new CategorizeTextAggregationBuilder(aggregationName), null));
    }

    private CategorizeTextAggregationBuilder(String name) {
        super(name);
    }

    public CategorizeTextAggregationBuilder(String name, String fieldName) {
        super(name);
        this.fieldName = (String)ExceptionsHelper.requireNonNull((Object)fieldName, (ParseField)FIELD_NAME);
    }

    public boolean supportsSampling() {
        return true;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public CategorizeTextAggregationBuilder setFieldName(String fieldName) {
        this.fieldName = (String)ExceptionsHelper.requireNonNull((Object)fieldName, (ParseField)FIELD_NAME);
        return this;
    }

    public CategorizeTextAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before((VersionId)ALGORITHM_CHANGED_VERSION)) {
            throw new ElasticsearchStatusException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", RestStatus.BAD_REQUEST, new Object[0]);
        }
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.fieldName = in.readString();
        this.similarityThreshold = in.readVInt();
        this.categorizationAnalyzerConfig = (CategorizationAnalyzerConfig)in.readOptionalWriteable(CategorizationAnalyzerConfig::new);
    }

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public CategorizeTextAggregationBuilder setSimilarityThreshold(int similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
        if (similarityThreshold < 1 || similarityThreshold > 100) {
            throw ExceptionsHelper.badRequestException((String)"[{}] must be in the range [1, 100]. Found [{}] in [{}]", (Object[])new Object[]{SIMILARITY_THRESHOLD.getPreferredName(), similarityThreshold, this.name});
        }
        return this;
    }

    public CategorizeTextAggregationBuilder setCategorizationAnalyzerConfig(CategorizationAnalyzerConfig categorizationAnalyzerConfig) {
        if (this.categorizationAnalyzerConfig != null) {
            throw ExceptionsHelper.badRequestException((String)"[{}] cannot be used with [{}] - instead specify them as pattern_replace char_filters in the analyzer", (Object[])new Object[]{CATEGORIZATION_FILTERS.getPreferredName(), CATEGORIZATION_ANALYZER.getPreferredName()});
        }
        this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
        return this;
    }

    public CategorizeTextAggregationBuilder setCategorizationFilters(List<String> categorizationFilters) {
        if (categorizationFilters == null || categorizationFilters.isEmpty()) {
            return this;
        }
        if (this.categorizationAnalyzerConfig != null) {
            throw ExceptionsHelper.badRequestException((String)"[{}] cannot be used with [{}] - instead specify them as pattern_replace char_filters in the analyzer", (Object[])new Object[]{CATEGORIZATION_FILTERS.getPreferredName(), CATEGORIZATION_ANALYZER.getPreferredName()});
        }
        if (categorizationFilters.stream().distinct().count() != (long)categorizationFilters.size()) {
            throw ExceptionsHelper.badRequestException((String)"categorization_filters contain duplicates", (Object[])new Object[0]);
        }
        if (categorizationFilters.stream().anyMatch(String::isEmpty)) {
            throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"categorization_filters are not allowed to contain empty strings"), (Object[])new Object[0]);
        }
        for (String filter : categorizationFilters) {
            if (AnalysisConfig.Builder.isValidRegex((String)filter)) continue;
            throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"categorization_filters contains invalid regular expression ''{0}''", (Object[])new Object[]{filter}), (Object[])new Object[0]);
        }
        this.categorizationAnalyzerConfig = CategorizationAnalyzerConfig.buildStandardCategorizationAnalyzer(categorizationFilters);
        return this;
    }

    public CategorizeTextAggregationBuilder size(int size) {
        if (size <= 0) {
            throw ExceptionsHelper.badRequestException((String)"[{}] must be greater than 0. Found [{}] in [{}]", (Object[])new Object[]{TermsAggregationBuilder.REQUIRED_SIZE_FIELD_NAME.getPreferredName(), size, this.name});
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public CategorizeTextAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw ExceptionsHelper.badRequestException((String)"[{}] must be greater than 0. Found [{}] in [{}]", (Object[])new Object[]{TermsAggregationBuilder.SHARD_SIZE_FIELD_NAME.getPreferredName(), shardSize, this.name});
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public CategorizeTextAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw ExceptionsHelper.badRequestException((String)"[{}] must be greater than or equal to 0. Found [{}] in [{}]", (Object[])new Object[]{TermsAggregationBuilder.MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), minDocCount, this.name});
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public CategorizeTextAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw ExceptionsHelper.badRequestException((String)"[{}] must be greater than or equal to 0. Found [{}] in [{}]", (Object[])new Object[]{TermsAggregationBuilder.SHARD_MIN_DOC_COUNT_FIELD_NAME.getPreferredName(), shardMinDocCount, this.name});
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    protected CategorizeTextAggregationBuilder(CategorizeTextAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(clone.bucketCountThresholds);
        this.fieldName = clone.fieldName;
        this.similarityThreshold = clone.similarityThreshold;
        this.categorizationAnalyzerConfig = clone.categorizationAnalyzerConfig;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)ALGORITHM_CHANGED_VERSION)) {
            throw new ElasticsearchStatusException("[categorize_text] aggregation cannot be used in a cluster where some nodes have version [" + ALGORITHM_CHANGED_VERSION + "] or higher and others have a version before this", RestStatus.BAD_REQUEST, new Object[0]);
        }
        this.bucketCountThresholds.writeTo(out);
        out.writeString(this.fieldName);
        out.writeVInt(this.similarityThreshold);
        out.writeOptionalWriteable((Writeable)this.categorizationAnalyzerConfig);
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        return new CategorizeTextAggregatorFactory(this.name, this.fieldName, this.similarityThreshold, this.bucketCountThresholds, this.categorizationAnalyzerConfig, context, parent, subfactoriesBuilder, this.metadata);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.bucketCountThresholds.toXContent(builder, params);
        builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        builder.field(SIMILARITY_THRESHOLD.getPreferredName(), this.similarityThreshold);
        if (this.categorizationAnalyzerConfig != null) {
            this.categorizationAnalyzerConfig.toXContent(builder, params);
        }
        builder.endObject();
        return null;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new CategorizeTextAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    public String getType() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ALGORITHM_CHANGED_VERSION;
    }

    static {
        PARSER.declareString(CategorizeTextAggregationBuilder::setFieldName, FIELD_NAME);
        PARSER.declareInt(CategorizeTextAggregationBuilder::setSimilarityThreshold, SIMILARITY_THRESHOLD);
        PARSER.declareInt((p, c) -> {}, MAX_UNIQUE_TOKENS);
        PARSER.declareInt((p, c) -> {}, MAX_MATCHED_TOKENS);
        PARSER.declareField(CategorizeTextAggregationBuilder::setCategorizationAnalyzerConfig, (p, c) -> CategorizationAnalyzerConfig.buildFromXContentFragment((XContentParser)p, (boolean)false), CATEGORIZATION_ANALYZER, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareStringArray(CategorizeTextAggregationBuilder::setCategorizationFilters, CATEGORIZATION_FILTERS);
        PARSER.declareInt(CategorizeTextAggregationBuilder::shardSize, TermsAggregationBuilder.SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(CategorizeTextAggregationBuilder::minDocCount, TermsAggregationBuilder.MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(CategorizeTextAggregationBuilder::shardMinDocCount, TermsAggregationBuilder.SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(CategorizeTextAggregationBuilder::size, TermsAggregationBuilder.REQUIRED_SIZE_FIELD_NAME);
    }
}

