/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportEvaluateDataFrameAction
extends HandledTransportAction<EvaluateDataFrameAction.Request, EvaluateDataFrameAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;
    private final AtomicReference<Integer> maxBuckets = new AtomicReference();
    private final SecurityContext securityContext;
    private final ClusterService clusterService;

    @Inject
    public TransportEvaluateDataFrameAction(TransportService transportService, Settings settings, ActionFilters actionFilters, ThreadPool threadPool, Client client, ClusterService clusterService) {
        super("cluster:monitor/xpack/ml/data_frame/evaluate", transportService, actionFilters, EvaluateDataFrameAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.maxBuckets.set((Integer)MultiBucketConsumerService.MAX_BUCKET_SETTING.get(clusterService.getSettings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MultiBucketConsumerService.MAX_BUCKET_SETTING, this::setMaxBuckets);
        this.clusterService = clusterService;
    }

    private void setMaxBuckets(int maxBuckets) {
        this.maxBuckets.set(maxBuckets);
    }

    protected void doExecute(Task task, EvaluateDataFrameAction.Request request, ActionListener<EvaluateDataFrameAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ActionListener resultsListener = ActionListener.wrap(unused -> {
            EvaluateDataFrameAction.Response response = new EvaluateDataFrameAction.Response(request.getEvaluation().getName(), request.getEvaluation().getResults());
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0));
        EvaluationParameters parameters = new EvaluationParameters(this.maxBuckets.get().intValue());
        EvaluationExecutor evaluationExecutor = new EvaluationExecutor(this.threadPool, (Client)new ParentTaskAssigningClient(this.client, parentTaskId), parameters, request, this.securityContext);
        evaluationExecutor.execute(resultsListener);
    }

    private static final class EvaluationExecutor
    extends TypedChainTaskExecutor<Void> {
        private final Client client;
        private final EvaluationParameters parameters;
        private final EvaluateDataFrameAction.Request request;
        private final Evaluation evaluation;
        private final SecurityContext securityContext;

        EvaluationExecutor(ThreadPool threadPool, Client client, EvaluationParameters parameters, EvaluateDataFrameAction.Request request, SecurityContext securityContext) {
            super(threadPool.generic(), unused -> true, unused -> true);
            this.client = client;
            this.parameters = parameters;
            this.request = request;
            this.evaluation = request.getEvaluation();
            this.securityContext = securityContext;
            this.add(this.nextTask());
        }

        private TypedChainTaskExecutor.ChainTask<Void> nextTask() {
            return listener -> {
                SearchSourceBuilder searchSourceBuilder = this.evaluation.buildSearch(this.parameters, this.request.getParsedQuery());
                SearchRequest searchRequest = new SearchRequest(this.request.getIndices()).source(searchSourceBuilder);
                SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> this.client.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest, listener.delegateFailureAndWrap((l, searchResponse) -> {
                    this.evaluation.process(searchResponse);
                    if (!this.evaluation.hasAllResults()) {
                        this.add(this.nextTask());
                    }
                    l.onResponse(null);
                })));
            };
        }
    }
}

